/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 Ifremer, CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.datastore;

import java.util.EventListener;

/**
 * Listener for change made on storage.
 * 
 * Such as :
 * <li>region added</li>
 * <li>script removed</li>
 * <li>plan renamed</li>
 *
 * @author chatellier
 * @version $Revision: 1.0 $
 * 
 * Last update : $Date: 24 juil. 2009 $
 * By : $Author: chatellier $
 */
public interface StorageChangeListener extends EventListener {

    /**
     * Fire data changed event.
     * 
     * @param e event to fire
     */
    void versionDataChanged(StorageChangeEvent e);
}
