<?xml version="1.0" encoding="ISO-8859-1" standalone="yes"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:output method="xml" encoding="ISO-8859-1" indent="yes"/>

  <!-- Carbon copy as default -->
    <xsl:template match="@*|node()">
      <xsl:copy>
        <xsl:apply-templates select="@*|node()"/>
      </xsl:copy>
    </xsl:template>
<!--
  <xsl:template match="child::node()|attribute::*" priority="-10">
    <xsl:copy>
        <xsl:apply-templates select="attribute::*"/>
        <xsl:apply-templates select="child::node()"/>
    </xsl:copy>
  </xsl:template>
-->

  <!-- changement de version -->
  <xsl:template match="/dbobjects">
    <xsl:copy>
      <xsl:attribute name="version">2.3</xsl:attribute>
      <xsl:apply-templates select="child::*"/>
    </xsl:copy>
  </xsl:template>


  <!--
   |Rename attribute facteurCiblage to equation in EspecesCapturables object
   +-->
  <xsl:template match="dbobject/attribute[(@name='facteurCiblage') and (../@type='EspecesCapturables')]">
    <xsl:copy>
    <xsl:attribute name="name">equation</xsl:attribute>

    <xsl:variable name="infoid">
      <xsl:value-of select="../attribute[@name='infoSaisonMetier']/text()"/>
    </xsl:variable>
    <xsl:variable name="metierid">
      <xsl:value-of select="/descendant::attribute[(@name='metier') and (../@__id__=$infoid)]/text()"/>
    </xsl:variable>
    <xsl:variable name="metapopid">
      <xsl:value-of select="../attribute[@name='metaPopulation']/text()"/>
    </xsl:variable>


    <xsl:text>&lt;equation name="</xsl:text> <!-- <metier>[<mois>-<mois>] <metapop> -->
    <xsl:value-of select="/descendant::attribute[(@name='nom') and (../@__id__=$metierid)]/text()"/>
    <xsl:text>[first-last] </xsl:text>
    <xsl:value-of select="/descendant::attribute[(@name='nomEspece') and (../@__id__=$metapopid)]/text()"/>
    <xsl:text>"&gt;&lt;![CDATA[</xsl:text>
    <xsl:value-of select="./text()"/>
    <xsl:text>]]&gt;&lt;/equation&gt;</xsl:text>
    </xsl:copy>
  </xsl:template>

</xsl:stylesheet>
