<?xml version="1.0" encoding="ISO-8859-1" standalone="yes"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:output method="xml" encoding="ISO-8859-1" indent="yes"/>

  <!-- Carbon copy as default -->
  <xsl:template match="child::node()|attribute::*" priority="-10">
    <xsl:copy>
        <xsl:apply-templates select="attribute::*"/>
        <xsl:apply-templates select="child::node()"/>
    </xsl:copy>
  </xsl:template>


  <!-- changement de version -->
  <xsl:template match="/dbobjects">
    <xsl:copy>
      <xsl:attribute name="version">2.2</xsl:attribute>
      <xsl:apply-templates select="child::*"/>
    </xsl:copy>
  </xsl:template>


  <!--
   | Add attribute coeff in MappingZoneReproZoneRecru
   +-->
  <xsl:template match="dbobject[@type='MappingZoneReproZoneRecru']">
    <xsl:copy>
        <xsl:apply-templates select="attribute::*"/>

        <xsl:element name="attribute">
            <xsl:attribute name="name">coeff</xsl:attribute>
            <xsl:text>1</xsl:text>
        </xsl:element>

        <xsl:apply-templates select="child::node()"/>
    </xsl:copy>
  </xsl:template>

</xsl:stylesheet>
