<?xml version="1.0" encoding="ISO-8859-1" standalone="yes"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:output method="xml" encoding="ISO-8859-1" indent="yes"/>

  <!-- Carbon copy as default -->
  <xsl:template match="child::node()|attribute::*" priority="-10">
    <xsl:copy>
        <xsl:apply-templates select="attribute::*"/>
        <xsl:apply-templates select="child::node()"/>
    </xsl:copy>
  </xsl:template>


  <!-- changement de version -->
  <xsl:template match="/dbobjects">
    <xsl:copy>
      <xsl:attribute name="version">2.1</xsl:attribute>
      <xsl:apply-templates select="child::*"/>
    </xsl:copy>
  </xsl:template>




  <!-- ajout de mortaliteNaturelleEquation sur population -->
  <!-- Add attribute mapfile in Region -->
  <xsl:template match="dbobject[@type='Population']">
    <xsl:copy>
        <xsl:apply-templates select="attribute::*"/>

        <xsl:variable name="popid">
          <xsl:value-of select="attribute::__id__"/>
        </xsl:variable>

        <xsl:element name="attribute">
          <xsl:attribute name="name">mortaliteNaturelleEquation</xsl:attribute>

          <xsl:text>&lt;equation name="</xsl:text>
          <xsl:value-of select="./attribute[@name='nom']/text()"/>
          <xsl:text>"&gt;&lt;![CDATA[
result = ECMAScript(#
</xsl:text>
          <xsl:text>    if (classe == -1) </xsl:text><xsl:value-of select="./attribute[@name='mortNatClasseNaissance']/text()"/><xsl:text>;
</xsl:text>
          <xsl:for-each select="/descendant::attribute[(@name='population') and (text()=$popid) and (../@type='ClassePopulation')]/..">
      <xsl:sort select="./attribute[@name='id']" data-type="number"/>

          <xsl:variable name="classeid">
            <xsl:value-of select="./attribute[@name='id']/text()"/>
          </xsl:variable>
          <xsl:variable name="mortaliteNaturelle">
            <xsl:value-of select="./attribute[@name='mortaliteNaturelle']/text()"/>
          </xsl:variable>

          <xsl:text>    else if (classe.getId() == </xsl:text><xsl:value-of select="$classeid"/><xsl:text>) </xsl:text><xsl:value-of select="$mortaliteNaturelle"/><xsl:text>;
</xsl:text>
          </xsl:for-each>
          <xsl:text>    else 0;
#);

result
]]&gt;&lt;/equation&gt;</xsl:text>
        </xsl:element>

        <xsl:apply-templates select="child::node()"/>
    </xsl:copy>
  </xsl:template>


  <!-- suppression de mortaliteNaturelle sur ClassePopulation -->
  <xsl:template match="attribute[(@name='mortaliteNaturelle') and (../@type='ClassePopulation')]">
  </xsl:template>

  <!-- suppression de mortNatClasseNaissance sur Population -->
  <xsl:template match="attribute[(@name='mortNatClasseNaissance') and (../@type='Population')]">
  </xsl:template>


  <!-- Modify mortaliteNaturelle en mortaliteNaturelleEquation et passage de
   | float vers Equation dans ClassePopulation
   | equation name is: Poppulation.name + '.' + Classe.id
  <xsl:template match="attribute[(@name='mortaliteNaturelle') and (../@type='ClassePopulation')]">
    <xsl:copy>
       <xsl:attribute name="name">mortaliteNaturelleEquation</xsl:attribute>

      <xsl:variable name="popid">
        <xsl:value-of select="../attribute[@name='population']/text()"/>
      </xsl:variable>

      <xsl:text>&lt;equation name="</xsl:text>
      <xsl:value-of select="/descendant::attribute[(@name='nom') and (../@__id__=$popid)]/text()"/>
      <xsl:text>.</xsl:text>
      <xsl:value-of select="../attribute[@name='id']/text()"/>
      <xsl:text>"&gt;&lt;![CDATA[</xsl:text>
      <xsl:value-of select="text()"/>
      <xsl:text>]]&gt;&lt;/equation&gt;</xsl:text>
    </xsl:copy>
  </xsl:template>
   +-->


  <!-- Add attribute useMigrationEquation, migrationEquation,
   | emigrationEquation, immigrationEquation in InfoSaisonPop
   | and value it to false or empty
   +-->
  <xsl:template match="dbobject[@type='InfoSaisonPop']">
    <xsl:copy>
        <xsl:apply-templates select="attribute::*"/>

        <xsl:variable name="popid">
          <xsl:value-of select="./attribute[@name='population']/text()"/>
        </xsl:variable>

        <xsl:element name="attribute">
            <xsl:attribute name="name">useMigrationEquation</xsl:attribute>
            <xsl:text>false</xsl:text>
        </xsl:element>

        <xsl:element name="attribute">
            <xsl:attribute name="name">migrationEquation</xsl:attribute>
            <xsl:text>&lt;equation name="</xsl:text>
            <xsl:value-of select="/descendant::attribute[(@name='nom') and (../@__id__=$popid)]/text()"/>
            <xsl:text>.unset"&gt;&lt;![CDATA[]]&gt;&lt;/equation&gt;</xsl:text>
        </xsl:element>

        <xsl:element name="attribute">
            <xsl:attribute name="name">emigrationEquation</xsl:attribute>
            <xsl:text>&lt;equation name="</xsl:text>
            <xsl:value-of select="/descendant::attribute[(@name='nom') and (../@__id__=$popid)]/text()"/>
            <xsl:text>.unset"&gt;&lt;![CDATA[]]&gt;&lt;/equation&gt;</xsl:text>
        </xsl:element>

        <xsl:element name="attribute">
            <xsl:attribute name="name">immigrationEquation</xsl:attribute>
            <xsl:text>&lt;equation name="</xsl:text>
            <xsl:value-of select="/descendant::attribute[(@name='nom') and (../@__id__=$popid)]/text()"/>
            <xsl:text>.unset"&gt;&lt;![CDATA[]]&gt;&lt;/equation&gt;</xsl:text>
        </xsl:element>

        <xsl:apply-templates select="child::node()"/>
    </xsl:copy>
  </xsl:template>

</xsl:stylesheet>
