<?xml version="1.0" encoding="ISO-8859-1" standalone="yes"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:output method="xml" encoding="ISO-8859-1" indent="yes"/>

  <!-- Carbon copy as default -->
  <xsl:template match="child::node()|attribute::*" priority="-10">
    <xsl:copy>
        <xsl:apply-templates select="attribute::*"/>
        <xsl:apply-templates select="child::node()"/>
    </xsl:copy>
  </xsl:template>


  <!-- changement de version -->
  <xsl:template match="/dbobjects">
    <xsl:copy>
      <xsl:attribute name="version">1.9.1</xsl:attribute>
      <xsl:apply-templates select="child::*"/>
    </xsl:copy>
  </xsl:template>

  <!-- On encapsule les matrices pour le nouveau XMLEncoderDecoder -->
  <xsl:template match="attribute[(@name='distributionRepro') or (@name='matriceChangementLongueur') or (@name='etalementRecrutement')]">
    <xsl:copy>
      <xsl:apply-templates select="attribute::*"/>

      <xsl:variable name="id">
        <xsl:value-of select="text()"/>
      </xsl:variable>
      <xsl:text>&lt;object type=&quot;org.codelutin.math.matrix.MatrixNDImpl&quot;&gt;</xsl:text>
      <xsl:value-of select="text()"/>
      <xsl:text>&lt;/object&gt;</xsl:text>
    </xsl:copy>
  </xsl:template>

  <!-- On encapsule les matrices pour le nouveau XMLEncoderDecoder -->
  <xsl:template match="attribute[(@name='param') and (../@type='RegleGestion')]">
    <xsl:copy>
      <xsl:apply-templates select="attribute::*"/>

      <xsl:variable name="id">
        <xsl:value-of select="text()"/>
      </xsl:variable>
      <xsl:text>&lt;object type=&quot;fr.ifremer.nodb.RegleGestionParameter&quot;&gt;</xsl:text>
      <xsl:value-of select="text()"/>
      <xsl:text>&lt;/object&gt;</xsl:text>
    </xsl:copy>
  </xsl:template>

</xsl:stylesheet>
