<?xml version="1.0" encoding="ISO-8859-1" standalone="yes"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:output method="xml" encoding="ISO-8859-1" indent="yes"/>

  <!-- Carbon copy as default -->
  <xsl:template match="child::node()|attribute::*" priority="-10">
    <xsl:copy>
        <xsl:apply-templates select="attribute::*"/>
        <xsl:apply-templates select="child::node()"/>
    </xsl:copy>
  </xsl:template>


  <!-- changement de version -->
  <xsl:template match="/dbobjects">
    <xsl:copy>
      <xsl:attribute name="version">2.0</xsl:attribute>
      <xsl:apply-templates select="child::*"/>
    </xsl:copy>
  </xsl:template>

  <!-- Add attribute mapfile in Region -->
  <xsl:template match="dbobject[@type='Region']">
    <xsl:copy>
        <xsl:apply-templates select="attribute::*"/>
        <xsl:element name="attribute">
            <xsl:attribute name="name">mapfiles</xsl:attribute>
            <xsl:text></xsl:text>
        </xsl:element>
        <xsl:apply-templates select="child::node()"/>
    </xsl:copy>
  </xsl:template>


</xsl:stylesheet>
