<?xml version="1.0" encoding="ISO-8859-1" standalone="yes"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:output method="xml" encoding="ISO-8859-1" indent="yes"/>

  <!-- Carbon copy as default -->
  <xsl:template match="child::node()|attribute::*" priority="-10">
    <xsl:copy>
        <xsl:apply-templates select="attribute::*"/>
        <xsl:apply-templates select="child::node()"/>
    </xsl:copy>
  </xsl:template>


  <!-- changement de version et ajout de formules prexistante -->
  <xsl:template match="/dbobjects">
    <xsl:copy>
      <xsl:attribute name="version">1.9</xsl:attribute>
      <xsl:apply-templates select="child::*"/>
    </xsl:copy>
  </xsl:template>

  <!-- Add attribute price in ClassePopulation object and value it to 0 -->
  <xsl:template match="dbobject[@type='ClassePopulation']">
    <xsl:copy>
        <xsl:apply-templates select="attribute::*"/>
        <xsl:element name="attribute">
            <xsl:attribute name="name">price</xsl:attribute>
            <xsl:text>0</xsl:text>
        </xsl:element>
        <xsl:apply-templates select="child::node()"/>
    </xsl:copy>
  </xsl:template>

  <!-- Add attribute cost in Engin object and value it to 0 -->
  <xsl:template match="dbobject[@type='Engin']">
    <xsl:copy>
        <xsl:apply-templates select="attribute::*"/>
        <xsl:element name="attribute">
            <xsl:attribute name="name">cost</xsl:attribute>
            <xsl:text>0</xsl:text>
        </xsl:element>
        <xsl:apply-templates select="child::node()"/>
    </xsl:copy>
  </xsl:template>

  <!-- remove attribute strategies in Region object -->
  <xsl:template match="attribute[(@name='strategies') and (../@type='Region')]">
  </xsl:template>

</xsl:stylesheet>
