#!/bin/csh

cd "${isishome}"

#source /usr/share/modules/init/csh
#module load java/1.6.0

<#assign commonCommand="${javapath} -Xmx2000M -jar isis-fish*.jar --option launch.ui false --option perform.vcsupdate false --option perform.migration false --option perform.cron false" />
<#if qsubmutiplejob>
	<#-- localsimulationid is short simulation id version -->
	<#assign localsimulationid='${simulationid}_$PBS_ARRAY_INDEX' />
	<#if simulationstandalonezip>
		<#assign localsimulationzip='${simulationzip?replace("${simulationid}_[0-9]+", "${simulationid}_\\\\$PBS_ARRAY_INDEX","ri")}' />
	<#else>
		<#assign localsimulationzip='${simulationzip}' />
	</#if>
	<#assign localsimulationresultzip='${simulationresultzip?replace("${simulationid}_[0-9]+", "${simulationid}_\\\\$PBS_ARRAY_INDEX","ri")}' />
	<#assign localsimulationprescript='${simulationprescript?replace("${simulationid}_[0-9]+", "${simulationid}_\\\\$PBS_ARRAY_INDEX","ri")}' />
	<#assign localsimulationoutput='${isistemp}simulation-${simulationid}_$PBS_ARRAY_INDEX-output.txt' />
<#else>
	<#assign localsimulationid='${simulationid}' />
	<#assign localsimulationzip='${simulationzip}' />
	<#assign localsimulationresultzip='${simulationresultzip}' />
	<#assign localsimulationprescript='${simulationprescript}' />
	<#assign localsimulationoutput='${isistemp}simulation-${simulationid}-output.txt' />
</#if>
<#if simulationprescript?length &gt; 0>
${commonCommand} --simulateRemotellyWithPreScript "${localsimulationid}" "${localsimulationzip}" "${localsimulationresultzip}" "${localsimulationprescript}" >& "${localsimulationoutput}"
<#else>
${commonCommand} --simulateRemotelly "${localsimulationid}" "${localsimulationzip}" "${localsimulationresultzip}" >& "${localsimulationoutput}"
</#if>

rm -rf "$HOME/isis-database-3/simulations/${localsimulationid}"
