/* *##%
 *  Copyright (C) 2002-2009 Code Lutin, Benjamin Poussin
 * 
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 *  USA.
 *##%*/

package fr.ifremer.isisfish.vcs;

import fr.ifremer.isisfish.IsisConfig;
import java.io.File;
import static org.nuiton.i18n.I18n._;

import java.util.Properties;
import org.apache.commons.beanutils.ConstructorUtils;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * Permet de recupere le bon VCS en fonction de la configuration.
 *
 * @author poussin
 * @version $Revision: 2695 $
 * 
 * Last update : $Date: 2009-10-27 11:38:37 +0100 (mar., 27 oct. 2009) $
 * By : $Author: chatellier $
 */
public class VCSFactory {

    /** to use log facility, just put in your code: log.info(\"...\"); */
    private static Log log = LogFactory.getLog(VCSFactory.class);

    private VCSFactory() {}

    /**
     * VCSNone factory, looking for vcs.type key in config to find vcs class to used.
     * If no vcs.type found or is not valid class, use {@link VCSNone}.
     * 
     * @param config
     * @return usable VCSNone
     */
    static public VCS createVCS(IsisConfig config) {
        Properties aliases = new Properties();
        // for empty and TYPE_NONE we used this class
        aliases.setProperty("", VCSNone.class.getName());
        aliases.setProperty(VCS.TYPE_NONE, VCSNone.class.getName());
        aliases.setProperty(VCS.TYPE_SVN, VCSSVN.class.getName());
        
        VCS result = null;
        String type = config.getOption(VCS.VCS_TYPE);
        // try to convert if type is not class name but an alias
        String classname = aliases.getProperty(type, type);

        File dataDir = config.getDatabaseDirectory();
        String protocol = config.getOption(VCS.VCS_PROTOCOL);
        String host = config.getOption(VCS.VCS_HOST_NAME);
        String path = config.getOption(VCS.VCS_PATH);
        File sshKeyFile = config.getSSHPrivateKeyFilePath();
        String login = config.getOption(VCS.VCS_USER_NAME);
        String password = config.getOption(VCS.VCS_USER_PASSWORD);

        try {
            Class<?> clazz = (Class<?>) ConvertUtils.convert(classname, Class.class);
            result = (VCS) ConstructorUtils.invokeConstructor(clazz,
                    new Object[]{dataDir, protocol, host, path, sshKeyFile, login, password});
        } catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error(_("isisfish.vcs.factory.cantinstanciate", type), eee);
            }
            result = new VCSNone(dataDir, protocol, host, path, sshKeyFile, login, password);
        }
        return result;
    }

}
