/* *##%
 * Copyright (C) 2009 Code Lutin, Chatellier Eric
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *##%*/

package fr.ifremer.isisfish.util.ssh;

/**
 * Progress monitor (sftp).
 * 
 * @author chatellier
 * @version $Revision: 2822 $
 * 
 * @since 3.3.0.0
 * Last update : $Date: 2009-12-11 17:30:19 +0100 (ven., 11 déc. 2009) $
 * By : $Author$
 */
public class ProgressMonitor {

    /** Size of file to download. */
    protected long initFileSize = 0;

    /** Current dowloaded length. */
    protected long totalLength = 0;

    public void init(long max) {
        initFileSize = max;
        totalLength = 0;
    }

    public void count(long len) {
        totalLength += len;
    }

    public void end() {

    }
}
