/* *##%
 * Copyright (C) 2006
 *     Code Lutin, Cédric Pineau, Benjamin Poussin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *##%*/

/* *
 * DateConverter.java
 *
 * Created: 13 janv. 2006 01:13:41
 *
 * @author poussin
 * @version $Revision: 1526 $
 *
 * Last update: $Date: 2008-10-07 18:46:13 +0200 (mar., 07 oct. 2008) $
 * by : $Author: tchemit $
 */

package fr.ifremer.isisfish.util;

import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.Converter;

import fr.ifremer.isisfish.types.TimeUnit;


/**
 * Classe utilise pour convertir une chaine en un objet TimeUnit.
 * Utilisé pour la conversion et le stockage en propriete des parametres
 * @author poussin
 *
 */
public class TimeUnitConverter implements Converter {

    /* (non-Javadoc)
     * @see org.apache.commons.beanutils.Converter#convert(java.lang.Class, java.lang.Object)
     */
    public Object convert(Class type, Object value) {
        Object result;
        if (value instanceof TimeUnit) {
            result = value;
        } else if (value instanceof Number) {
            result = new TimeUnit(((Number)value).doubleValue());
        } else if (value instanceof String) {
            double d = Double.parseDouble(value.toString());
            result = new TimeUnit(d);
        } else {
            throw new ConversionException("Can't convert '" + value + "' to " + type.getName());
        }
        return result;
    }

}


