/* *##% Copyright (C) 2006 - 2010
 *          Ifremer, Code Lutin, Cédric Pineau, Benjamin Poussin
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307, USA. ##%
 */

package fr.ifremer.isisfish.util;

import org.apache.commons.beanutils.Converter;
import org.apache.commons.lang.StringEscapeUtils;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.topia.persistence.TopiaEntity;

import fr.ifremer.isisfish.types.Date;
import fr.ifremer.isisfish.types.Month;
import fr.ifremer.isisfish.types.TimeUnit;

/**
 * Classe utilisée pour convertir en chaine un objet Date, Month ou TopiaEntity.
 * Utilisé pour la conversion et le stockage en propriete des parametres.
 * 
 * Created: 12 janv. 2006 20:38:26
 * 
 * @author poussin
 * 
 * @version $Revision: 2908 $
 * 
 * Last update: $Date: 2010-01-13 15:18:36 +0100 (mer., 13 janv. 2010) $
 * by : $Author: chatellier $
 */
public class StringConverter implements Converter {

    protected Converter defaultStringConverter = new org.apache.commons.beanutils.converters.StringConverter();

    /*
     * @see org.apache.commons.beanutils.Converter#convert(java.lang.Class, java.lang.Object)
     */
    public Object convert(Class type, Object o) {
        Object result = null;
        if (o != null) {
            if (o instanceof TopiaEntity) {
                result = ((TopiaEntity) o).getTopiaId();
            } else if (o instanceof Date) {
                result = String.valueOf(((Date) o).getDate());
            } else if (o instanceof Month) {
                result = String.valueOf(((Month) o).getMonthNumber());
            } else if (o instanceof TimeUnit) {
                result = String.valueOf(((TimeUnit) o).getTime());
            // Not used since mexico file format use
            // Still used in sensivity analysis prescript
            } else if (o instanceof MatrixND) {
                MatrixConverter converter = new MatrixConverter();
                result = converter.getMatrixAsString((MatrixND)o);
                result = StringEscapeUtils.escapeJava((String)result);
            } else {
                // dans tous les autres cas, on appelle le converter par defaut
                result = defaultStringConverter.convert(type, o);
            }
        }
        return result;
    }

}
