/* *##%
 * Copyright (C) 2009 Code Lutin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *##%*/

package fr.ifremer.isisfish.util;

/**
 * This is the contract to be realize by any class which wanted to have a @Doc support.
 *
 * @author chemit
 * @see Doc
 * @see DocHelper
 * @version $Revision: 2088 $
 * 
 * Last update : $Date: 2009-04-08 12:24:31 +0200 (mer., 08 avril 2009) $
 * By : $Author: chatellier $
 */
public interface Docable {

    /**
     * Class documentation (if any).
     * 
     * @return the @Doc of the class, or null if none
     */
    Doc getClassDoc();

    /**
     * Field documentation (if any).
     * 
     * @param fieldName name of the field to use
     * @return the @Doc of the field, or null if none
     */
    Doc getFieldDoc(String fieldName);

    /**
     * Class documentation (if any).
     * 
     * @return the description of the class, or null if none
     */
    String getDescription();
}
