/* *##%
 * Copyright (C) 2009 Code Lutin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *##%*/

package fr.ifremer.isisfish.util;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Used by user to add informations about a code he wrote.
 * 
 * @author chemit
 * @version $Revision: 2507 $
 * 
 * Last update : $Date: 2009-07-20 15:38:55 +0200 (lun., 20 juil. 2009) $
 * By : $Author: chatellier $
 */
@Retention(value = RetentionPolicy.RUNTIME)
@Target(value = { ElementType.FIELD })
public @interface Doc {

    /**
     * Get content of the documentation.
     * 
     * @return the content of the documentation
     */
    String value();

    /**
     * Get documentation date (optional).
     * 
     * @return optional date
     */
    String date() default "";

    /**
     * Get documentation version (optional).
     * 
     * @return optional version
     */
    String version() default "";

    /**
     * Get documentation author (optional).
     * 
     * @return optional author of the documentation
     */
    String author() default "";
}
