package fr.ifremer.isisfish.ui.widget.filter;

import fr.ifremer.isisfish.ui.widget.filter.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.Table;
import static org.nuiton.i18n.I18n._;
import static jaxx.runtime.Util.createImageIcon;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.JAXXObject;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.HTMLDocument;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import javax.swing.event.HyperlinkEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.nuiton.widget.DatePicker;
import org.nuiton.widget.InvalidDateException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FilterDialogUI extends javax.swing.JDialog implements jaxx.runtime.JAXXObject {
    public static final Log log = LogFactory.getLog(fr.ifremer.isisfish.ui.widget.filter.FilterDialogUI.class);
    private static java.lang.String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUz08TQRQeCpQfBUFE1ATDD9EYD1sEEgwQVEAipKABSYi9ON0d2sHpzrrzFpaLMfFqDCcPXtS7R+/GePTk1f/BGP8D38z215Km1NDDbvve933zvdd57/Nv0q58MrZPw9DyAxd4kVnr93d3H+X2mQ0rTNk+90D6JPq0JEgiS1JOJa6AXMtmND1doqeXZdGTLnNr2PMZ0q3gSDBVYAyAXIwYtlLp7Up4PvQCv6xWMVNP7ePfP4lj59WnBCGhh656sITR01jVCtoyJMEdIAN40gFNC+rm0YbP3Tz67NWxZUGV2qRF9oK8JB0ZkvSoj2JAxpsv1WgYfugB6ZpYX+FUyPwkkOk93+J7PisyfCuu9rgqWAG3DrmTZ2DtcQGYWTWviLSz5nlGKwmkY+IJzQl2G8jlWMnqEAuwTE4juyqE3on1bduXQjymLpsCcklXGJbwNSkN76mwWh1pn8Q+cDhWWMb2VS3Z0gXTn6n/KE3riJ21+LE9aJZhtykeNA1kKO61nIlzUoLmmNhiKhBoYSBGyejUCbgtizlZho/UaaIegGUNWpJhnNs5sW5sz5w8x0Tj2IR8DuRCDLUUAEhX58cqsHafKQb6x414ImlT145Eyxlf66FdHByrOjjVm92SRbkAw0D6s9UZ28JQNF2lqBEw0Q+v3x+8+/J1rjxKKTyjNwapmXy82p4vPeYD10f0RfMTABfpDerNZ0mXYgLXhlkLgzUGtkthNIH65zXN0jTrIVUFpLZ3/Pr2fejZz1aSWCXdQlJnlWr8GumCAvanIIUTenfvGSc9h5347NeesEkFxvMF/bcvcFdwl41SwFHOBcAWQyx4sKbgiosfx282ht9enS0X3RKZOgGrFt7+lCQjdbM5Skuh7qZIeYoFjqwOf7110KLf/V5ppifNc6ZedSnpc5wrCjy6NbNhoF93jGf9bc5IXWlCqtMMyar0gZxbcCjQ0Rx3HbyVi/U1h5vQbAMWQgNfzWh0MFevLNPUlfoyI03IJAU9kgE0UBk/VUWHNxsoXG9KYa1BQ5pTaOTh5pk9nF3hFir8A1OUR/o5CAAA";
    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected java.util.Map<String,Object> $bindingSources = new HashMap<String,Object>();
    protected Map<String,Object> $objectMap = new HashMap<String,Object>();
    protected javax.swing.JButton cancel;
    protected jaxx.runtime.swing.JAXXComboBox comboResult;
    protected fr.ifremer.isisfish.ui.widget.filter.FilterPanelUI content;
    protected final jaxx.runtime.JAXXContext delegateContext = new jaxx.runtime.DefaultJAXXContext(this);;
    protected javax.swing.JEditorPane doc;
    protected javax.swing.JLabel labelResult;
    protected javax.swing.JButton ok;
    protected javax.swing.JButton reset;
    private fr.ifremer.isisfish.ui.widget.filter.FilterDialogUI $JDialog0 = this;
    private javax.swing.JPanel $JPanel4;
    private javax.swing.JScrollPane $JScrollPane2;
    private javax.swing.JSeparator $JSeparator3;
    private jaxx.runtime.swing.Table $Table1;
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    java.util.Map $previousValues = new java.util.HashMap();
    private java.beans.PropertyChangeListener $DataSource6 = new jaxx.runtime.DataBindingListener($JDialog0, "comboResult.enabled");
    private java.beans.PropertyChangeListener $DataSource8 = new jaxx.runtime.DataBindingListener($JDialog0, "ok.enabled");

    /* begin raw body code */
    /** filter model */
        protected fr.ifremer.isisfish.ui.widget.filter.FilterModel model;
    /** use to display filtered result in a comboBox */
        protected DefaultComboBoxModel modelResult;
    
          
        public fr.ifremer.isisfish.ui.widget.filter.FilterParamModel getParamModel(String paramKey) {
            return model.getParamModel(paramKey);
        }
        @SuppressWarnings({"unchecked"})
        public java.util.List getOriginal() {
            return model.getOriginal();
        }
        /** @return list of last filter list obtain */
        @SuppressWarnings({"unchecked"})
        protected java.util.List getFilterResult() {
            // obtain list filtered
            return model.getFiltered();
        }
        @SuppressWarnings({"unchecked"})
        public java.util.List obtainFilterResult() {
            // compact dialog
            setSize(getMinimumSize());
            repaint();
            doReset();
            // TODO pas de composant parent ?
            org.nuiton.widget.SwingUtil.center(this);
            // launch ui and waits for reply
            setVisible(true);
            return model.getFilteredResult();
        }
        public String obtainSelectResult() {
            // compact dialog
            setSize(getMinimumSize());
            repaint();
            doReset();
            // TODO pas de composant parent ?
            org.nuiton.widget.SwingUtil.center(this);
            // launch ui and waits for reply
            setVisible(true);
            return (String) comboResult.getSelectedItem();
        }
        /**
         * user ui action : reset previous filter results (if any) and restore
         * original dialogModel
         *
         * @see FilterModel#reset()
         */
        @SuppressWarnings({"unchecked"})
        public void doReset() {
            content.doReset();
            model.reset();
            model.selectAll();
            refreshResult();
        }
        /**
         * user ui action : check nb matchs found with current params (launch a
         * filter process)
         */
        public void doCheck() {
            // launch new filter process (previous result is lost)
            doFilter();
            // refresh ui nbMatchsFound
            refreshResult();
        }
        /**
         * launch filter process with params grabbed in ui
         *
         * @see FilterModel#doFilter()
         */
        public void doFilter() {
            // rest model before all
            model.reset();
            // synchronize ui values to model
            content.uiToModel();
            // delegate to FilterModel the filter process
            model.doFilter();
        }
        public void doCancel() {        
            // reset ui
            content.doReset();
            // reset model
            model.reset();
            //refreshResult();
            dispose();
        }
        protected boolean canReset() {
            return !(model == null || model.getNbResult() == model.getNbOriginal());
        }
        protected HyperlinkListener createHyperLinkListener() {
            return new HyperlinkListener() {
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        if (e instanceof HTMLFrameHyperlinkEvent) {
                            ((HTMLDocument)doc.getDocument()).processHTMLFrameHyperlinkEvent(
                                (HTMLFrameHyperlinkEvent)e);
                        } else {
                            try {
                                if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                                    Desktop.getDesktop().browse(e.getURL().toURI());
                                } else {
                                    doc.setPage(e.getURL());
                                }
                            } catch (Exception eee) {
                                if (log.isErrorEnabled()) {
                                    log.error("Can't open system browser", eee);
                                }
                            }
                        }
                    }
                }
            };
        }
        protected void refreshResult() {
            if (model == null) return;
            labelResult.setText(_("isisfish.filter.result.found", model.getNbResult(), model.getNbOriginal()));
    
            if (getComboResult() != null) {
                if (modelResult == null) {
                    jaxx.runtime.Util.assignment(modelResult = new DefaultComboBoxModel(), "modelResult", fr.ifremer.isisfish.ui.widget.filter.FilterDialogUI.this);
                    getComboResult().setModel(modelResult);
                } else {
                    modelResult.removeAllElements();
                    for (Object o : model.getFilteredResult()) {
                        modelResult.addElement(o);
                    }
                }
            }
            processDataBinding("comboResult.enabled");
            processDataBinding("ok.enabled");
        }
    /* end raw body code */
    /*---------------------------------------------------------------------------------*/
    /*-- Statics methods --------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public static jaxx.runtime.JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return jaxx.runtime.Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Constructors -----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public FilterDialogUI() {
        $initialize();
    }

    public FilterDialogUI(jaxx.runtime.JAXXContext parentContext) {
        if (parentContext instanceof jaxx.runtime.JAXXInitialContext) {
            ((jaxx.runtime.JAXXInitialContext)parentContext).to(this);
        } else {
            setContextValue(parentContext);
        }
        $initialize();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXObject implementation ----------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void applyDataBinding(String $binding) {
        if ("comboResult.enabled".equals($binding)) {
            if (comboResult != null) {
                comboResult.addPropertyChangeListener("model", $DataSource6);
            }
        } else if ("ok.enabled".equals($binding)) {
            if (comboResult != null) {
                comboResult.addPropertyChangeListener("model", $DataSource8);
            }
        }
        processDataBinding($binding);
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    public Map<String,Object> get$objectMap() {
        return $objectMap;
    }

    public java.lang.Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    public void processDataBinding(String dest) {
        processDataBinding(dest, false);
    }

    public void processDataBinding(String $dest, boolean $force) {
        if (!$force && $activeBindings.contains($dest)) { 
            return;
        }
        $activeBindings.add($dest);
        try {
            if ("comboResult.enabled".equals($dest)) {
            if (comboResult != null) {
                comboResult.setEnabled((comboResult.getModel().getSize()!=0));
            }
            } else if ("ok.enabled".equals($dest)) {
            if (comboResult != null) {
                ok.setEnabled((comboResult.getModel().getSize()!=0));
            }
            }} finally {
            $activeBindings.remove($dest);
        }
    }

    public void removeDataBinding(String $binding) {
        if ("comboResult.enabled".equals($binding)) {
            if (comboResult != null) {
                comboResult.removePropertyChangeListener("model", $DataSource6);
            }
        } else if ("ok.enabled".equals($binding)) {
            if (comboResult != null) {
                comboResult.removePropertyChangeListener("model", $DataSource8);
            }
        }
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXContext implementation ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    public jaxx.runtime.JAXXContext getDelegateContext() {
        return delegateContext;
    }

    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return delegateContext.getParentContainer(clazz);
    }

    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return delegateContext.getParentContainer(source, clazz);
    }

    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Event methods ----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void doActionPerformed__on__cancel(java.awt.event.ActionEvent event) {
        doCancel();
    }

    public void doActionPerformed__on__ok(java.awt.event.ActionEvent event) {
        dispose();
    }

    public void doActionPerformed__on__reset(java.awt.event.ActionEvent event) {
        doReset();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public acessor methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public java.util.List<Object> get$activeBindings() {
        return $activeBindings;
    }

    public java.util.Map<String,Object> get$bindingSources() {
        return $bindingSources;
    }

    public javax.swing.JButton getCancel() {
        return cancel;
    }

    public jaxx.runtime.swing.JAXXComboBox getComboResult() {
        return comboResult;
    }

    public fr.ifremer.isisfish.ui.widget.filter.FilterPanelUI getContent() {
        return content;
    }

    public javax.swing.JEditorPane getDoc() {
        return doc;
    }

    public javax.swing.JLabel getLabelResult() {
        return labelResult;
    }

    public javax.swing.JButton getOk() {
        return ok;
    }

    public javax.swing.JButton getReset() {
        return reset;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- protected acessors methods ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    protected fr.ifremer.isisfish.ui.widget.filter.FilterDialogUI get$JDialog0() {
        return $JDialog0;
    }

    protected javax.swing.JPanel get$JPanel4() {
        return $JPanel4;
    }

    protected javax.swing.JScrollPane get$JScrollPane2() {
        return $JScrollPane2;
    }

    protected javax.swing.JSeparator get$JSeparator3() {
        return $JSeparator3;
    }

    protected jaxx.runtime.swing.Table get$Table1() {
        return $Table1;
    }

    protected java.lang.String get$jaxxObjectDescriptor() {
        return $jaxxObjectDescriptor;
    }

    protected java.util.Map get$previousValues() {
        return $previousValues;
    }

    protected boolean getAllComponentsCreated() {
        return allComponentsCreated;
    }

    protected boolean getContextInitialized() {
        return contextInitialized;
    }

    protected Log getLog() {
        return log;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- ui creation methods ----------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        $JDialog0.getContentPane().add($Table1);
        
        $Table1.add($JScrollPane2, new GridBagConstraints(0, 0, 4, 1, 0.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(content, new GridBagConstraints(0, 1, 4, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JSeparator3, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(labelResult, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(comboResult, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JPanel4, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        $JScrollPane2.getViewport().add(doc);
        
        
        $JPanel4.add(ok);
        $JPanel4.add(reset);
        $JPanel4.add(cancel);
        
        labelResult.setLabelFor((comboResult));
        applyDataBinding("comboResult.enabled");
        applyDataBinding("ok.enabled");
        reset.setEnabled((canReset()));
        $JDialog0.pack();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$JDialog0", this);
        $Table1 = new jaxx.runtime.swing.Table();
        $objectMap.put("$Table1", $Table1);
        $Table1.setName("$Table1");
        
        $JScrollPane2 = new javax.swing.JScrollPane();
        $objectMap.put("$JScrollPane2", $JScrollPane2);
        $JScrollPane2.setName("$JScrollPane2");
        jaxx.runtime.Util.setComponentHeight($JScrollPane2,200);
        
        
        createDoc();
        createContent();
        
        $JSeparator3 = new javax.swing.JSeparator();
        $objectMap.put("$JSeparator3", $JSeparator3);
        $JSeparator3.setName("$JSeparator3");
        $JSeparator3.setOrientation(0);
        
        createLabelResult();
        createComboResult();
        
        $JPanel4 = new javax.swing.JPanel();
        $objectMap.put("$JPanel4", $JPanel4);
        $JPanel4.setName("$JPanel4");
        $JPanel4.setLayout((new GridLayout(0, 3, 2, 2)));
        
        createOk();
        createReset();
        createCancel();
        $JDialog0.setName("$JDialog0");
        
        
        setModalityType(Dialog.ModalityType.APPLICATION_MODAL);doc.setEditable(false);doc.setEditorKit(new HTMLEditorKit());doc.addHyperlinkListener(createHyperLinkListener());
        $completeSetup();
    }

    protected void createCancel() {
        cancel = new javax.swing.JButton();
        $objectMap.put("cancel", cancel);
        cancel.setName("cancel");
        cancel.setText(_("isisfish.filter.cancel"));
        cancel.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JDialog0, "doActionPerformed__on__cancel"));
    }

    protected void createComboResult() {
        comboResult = new jaxx.runtime.swing.JAXXComboBox();
        $objectMap.put("comboResult", comboResult);
        comboResult.setName("comboResult");
    }

    protected void createContent() {
        content = new fr.ifremer.isisfish.ui.widget.filter.FilterPanelUI();
        $objectMap.put("content", content);
        content.removeDataBinding("$JPanel0.name");
        
        content.setName("content");
    }

    protected void createDoc() {
        doc = new javax.swing.JEditorPane();
        $objectMap.put("doc", doc);
        doc.setName("doc");
    }

    protected void createLabelResult() {
        labelResult = new javax.swing.JLabel();
        $objectMap.put("labelResult", labelResult);
        labelResult.setName("labelResult");
        labelResult.setText(_("isisfish.filter.result"));
    }

    protected void createOk() {
        ok = new javax.swing.JButton();
        $objectMap.put("ok", ok);
        ok.setName("ok");
        ok.setText(_("isisfish.filter.apply"));
        ok.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JDialog0, "doActionPerformed__on__ok"));
    }

    protected void createReset() {
        reset = new javax.swing.JButton();
        $objectMap.put("reset", reset);
        reset.setName("reset");
        reset.setText(_("isisfish.filter.reset"));
        reset.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JDialog0, "doActionPerformed__on__reset"));
    }

}
