package fr.ifremer.isisfish.ui.widget.filter;

import java.util.List;

/**
 * Contrat à respecter pour qu'un dialogue puisse bénéficier du mécanisme de
 * filtre.
 * <p/>
 *
 * Cette méthode est invoquée lors d'un appel à {@link #doFilter()} ou
 * {@link #doCheck()}.
 * <p/>
 * La méthode {@link #doReset()} permet de réinitialiser le dialogModel
 * (et le dialogue)
 */
public interface FilterDialog<M, R> {

    /**
     * launch filter proccess.
     * <p/>
     * This operation acts in three step :
     * <ul><li>clean model</li>
     * <ul><li>push ui values to model </li>
     * <li> for all original items and only for detected as usable params
     * try to accept item</li>
     * </ul>
     */
    void doFilter();

    /** invoke method {@link #doFilter()} then refresh ui  */
    void doCheck();

    /** réinitialisie le model et rafraichit l'ui */
    void doReset();

    /**
     * Display dialog and waits until user validate a filter result, or cancel
     * (then return <code>null</code>)
     *
     * @return list of filtered result of defined result format
     *         (of type <code>T</code>)
     */
    List<R> obtainFilterResult();

    /**
     * Display dialog and waits until user validate a selected result from a
     * filter result, or cancel (then return <code>null</code>)
     *
     * @return the selected result from filter result as defined result format
     *         (of type <code>T</code>)
     */
    R obtainSelectResult();

    /** @return list of original items (delegate to model) */
    List<M> getOriginal();
}
