package fr.ifremer.isisfish.ui.widget.filter;

/** class that represent a date interval stored in long object */
public class DateInterval implements java.io.Serializable {
    long d0, d1;
    private static final long serialVersionUID = 219393521548480987L;

    public DateInterval(long d0, long d1) {
        this.d0 = d0;
        this.d1 = d1;
    }

    public long getD0() {
        return d0;
    }

    public long getD1() {
        return d1;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        DateInterval that = (DateInterval) o;

        return d0 == that.d0 && d1 == that.d1;
    }

    public int hashCode() {
        int result;
        result = (int) (d0 ^ (d0 >>> 32));
        result = 31 * result + (int) (d1 ^ (d1 >>> 32));
        return result;
    }

    @Override
    public String toString() {
        return super.toString() + " <" + d0 + " - " + d1 + ">";
    }
}
