package fr.ifremer.isisfish.ui.widget.filter;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * this class is a concrete implementation of {@link FilterAcceptor}
 * with an internal {@link Acceptor} (delegate Acceptor  operations),
 * and an internal {@link ValueGetter} (delegate ValueGetter operations)
 * <p/>
 *
 * @author chemit
 * @see Acceptor
 * @see FilterAcceptor
 * @see ValueGetter
 */
public class CompositeFilterAcceptor<M, T> implements FilterAcceptor<M, T> {

    static private Log log = LogFactory.getLog(CompositeFilterAcceptor.class);

    /** delegate Acceptor */
    protected Acceptor<T> acceptor;

    /** delegate ValueGetter */
    protected ValueGetter<M, T> getter;

    public CompositeFilterAcceptor(Class<T> klazz, ValueGetter<M, T> getter) {
        this(AcceptorFactory.getAcceptor(klazz), getter);
    }

    public CompositeFilterAcceptor(Acceptor<T> acceptor, ValueGetter<M, T> getter) {
        this.acceptor = acceptor;
        this.getter = getter;
    }

    ///////////////////////////////////
    // FilterDialog implementation
    ///////////////////////////////////

    public boolean acceptParam(M item, T value) {
        return accept(getValue(item), value);
    }

    ///////////////////////////////////
    // ValueGetter implementation
    ///////////////////////////////////

    public T getValue(M model) {
        // we assume that we also need to extract value from model
        // anyway if we have the already good type it will just return it
        return extract(getter.getValue(model));
    }

    ///////////////////////////////////
    // Acceptor implementation
    ///////////////////////////////////

    public Class<T> getKlazz() {
        return acceptor.getKlazz();
    }

    public boolean canUse(Object[] val) {
        return acceptor.canUse(val);
    }

    public boolean accept(T meta, T value) {
        return acceptor.accept(meta, value);
    }

    @SuppressWarnings({"unchecked"})
    public T extract(Object args) {
        return args == null || getKlazz().isAssignableFrom(args.getClass()) ?
                (T) args : acceptor.extract(args);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(' ').append(acceptor);
        sb.append(' ').append(getter);
        return sb.toString();
    }
}
