/* *##%
 * Copyright (C) 2002 - 2009 Code Lutin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *##%*/

package fr.ifremer.isisfish.ui.widget;

import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

/**
 * FormInterval.
 */
public class FormInterval extends Frame {
    
    /** serialVersionUID. */
    private static final long serialVersionUID = 4911081593147906648L;

    class QuitListener extends WindowAdapter {
        public void windowClosing(WindowEvent e) {
            e.getWindow().dispose();
        }
    }

    public FormInterval(Interval i) {
        IntervalPanel ip = new IntervalPanel();
        this.add(ip);
        // 	ip.setEnabled(false);
        ip.setModel(i);

        this.addWindowListener(new QuitListener());
        pack();
    }
}
