package fr.ifremer.isisfish.ui.vcs;

import fr.ifremer.isisfish.ui.vcs.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.Table;
import static org.nuiton.i18n.I18n._;
import static jaxx.runtime.Util.createImageIcon;
import jaxx.runtime.SwingUtil;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.KeyPair;
import org.nuiton.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VCSGenerateSshKeyUI extends javax.swing.JDialog implements jaxx.runtime.JAXXObject {
    public static final Log log = LogFactory.getLog(fr.ifremer.isisfish.ui.vcs.VCSGenerateSshKeyUI.class);
    private static java.lang.String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKWUz08TQRTHh0pbyg/lR0FCICIQjQe3KkaiEJQfKYpFUZAQe3G6O6WD0911ZrYsHoyJV2M4efCi3j16N8ajJ6/+D8b4H/hmd/tjay1N2sNu+3585vte571Pv1BUcHR2H7uuxh1T0iLR1pd2d+/n9okuV4nQObWlxZH/6YigSBb1GBW7kGg6m1HpqSA9tWIVbcskZk32fAZ1C3nIiCgQIiUa9jN0IVJbFfO8azu8TKuIaUT78Od35Mh4+TGCkGuDqj4oYfK4rGoFnRkUoYZEg3BSCacYNvdABqfmHujsU7YVhoW4h4vkGXqB4hkUszEHmERTrZfqMbx815YoMbO+SjGz9i5JpOW5RvOcFAm8BRV5KgqaQ7WSLrSdla01YhKOJdkShbvk8NEd2/YwMYniM9s4x8hliUZD1YoD0K55PhWZqCR0zaxncI6wK1CsqssNQn2rCuqtxCYF4SXCNzktweFwcpoyItFIKG+buDJNCTPCueVzZtXvgbBvKOA6OUb1AKtcyXDYcBAGTdsscCxIRWIdr78+UKKxkEblObC40UDnuJ+7Ypl5yovHn3X6P/HKPfFPCzaxSdjV+lZ71nBsxHoKfQlFLTtSWqbyT1XCenVs6oQt6ZL6rvOBn6tk+P9hfrTq/FQveEcWRbkDZuhWtjpqD8HkD1lg9QCe9f2rd6W3n7/cKE/UIJzRFwqpWQBww21u2YRLqo445Y+RIylLbWB7PosSgjDYHt52SNYI2ArMIAL4AypNU2nabSwKkBqN//z6beTJjxMokkbdzMJGGqv4OyghCxyqtJjh2jdveUp6D7rg2a80SRQtWgZm0PoFajJqkkksYaBzjiSLLtSbrKm3IuL70euN8TcTc+WaO3xNdWHVuqOPUcyne/sjWA0N90WPLYhjWNUV0GgpdKh3tx2Md8p7zjYsTlLpz8w111GvOU+t+na9ZUinhNFtwuhvgRHXLeYUTdEEM9QCposYVJaXVRucRN4y5UVBn7cLihUI3Ss0687xFGVebkIYaYmw1oQw2hIh0zbhQduEnbYJzTo51jbhTCt3guFDC5YyOrlgYIknc9Q0YFMvNiZOtzI9xFSX3mgi7FzbpbVPuACEv4FBXOsXCgAA";
    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected java.util.Map<String,Object> $bindingSources = new HashMap<String,Object>();
    protected Map<String,Object> $objectMap = new HashMap<String,Object>();
    protected javax.swing.JButton cancelAction;
    protected final jaxx.runtime.JAXXContext delegateContext = new jaxx.runtime.DefaultJAXXContext(this);;
    protected javax.swing.JButton ok;
    protected javax.swing.JPasswordField serverConfirmPassPhrase;
    protected javax.swing.JLabel serverConfirmPassPhraseLabel;
    protected javax.swing.JPasswordField serverPassPhrase;
    protected javax.swing.JLabel serverPassPhraseLabel;
    protected javax.swing.JTextField serverPrivateKeyFile;
    protected javax.swing.JTextField serverPublicKeyFile;
    private fr.ifremer.isisfish.ui.vcs.VCSGenerateSshKeyUI $JDialog0 = this;
    private javax.swing.JLabel $JLabel2;
    private javax.swing.JLabel $JLabel3;
    private javax.swing.JPanel $JPanel4;
    private jaxx.runtime.swing.Table $Table1;
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    java.util.Map $previousValues = new java.util.HashMap();

    /* begin raw body code */
    private static VCSGenerateSshKeyUI instance;
    
    
        public static VCSGenerateSshKeyUI getInstance(JDialog parent) {
            if (instance == null) {
                instance = new VCSGenerateSshKeyUI(parent);
            }
            return instance;
        }public boolean cancel;
    public boolean noPassPhrase;
    public Exception error;
    protected boolean invalidPassPhrase;
    protected String vcsLogin;
    
    
        private  VCSGenerateSshKeyUI(JDialog instance) {
            super(instance);$initialize();
    
            // block close operation
            setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);
            
             
        $initialize();
    }
    
        public void setData(String vcsLogin, File privateKeyFile) {
            this.vcsLogin = vcsLogin ;
            serverPrivateKeyFile.setText(privateKeyFile.getAbsolutePath());
            serverPublicKeyFile.setText(privateKeyFile.getAbsolutePath() + ".pub");
            jaxx.runtime.Util.assignment(noPassPhrase=true, "noPassPhrase", fr.ifremer.isisfish.ui.vcs.VCSGenerateSshKeyUI.this);
            jaxx.runtime.Util.assignment(error=null, "error", fr.ifremer.isisfish.ui.vcs.VCSGenerateSshKeyUI.this);
            doCheck();
        }
    
        /**
         * Generate ssh key.
         *
         * Return true if error occurs.
         */
        protected boolean doGenerate() {
            File privateKeyFile = new File(getServerPrivateKeyFile().getText());
            File publicKeyFile = new File(serverPublicKeyFile.getText());
            
            // bug #1623, le dossier parent n'existe pas
            if (privateKeyFile.getParentFile() != null && !privateKeyFile.getParentFile().exists()) {
                privateKeyFile.getParentFile().mkdirs();
            }
            
            try {
                char[] password = getServerPassPhrase().getPassword();
                
                JSch jsch=new JSch();
                KeyPair kpair=KeyPair.genKeyPair(jsch, KeyPair.RSA, 2048);
                if (password.length > 0) {
                    kpair.setPassphrase(Arrays.toString(password));
                }
                kpair.writePrivateKey(privateKeyFile.getAbsolutePath());
                kpair.writePublicKey(publicKeyFile.getAbsolutePath(), vcsLogin + "@forIsisFish");
                if (log.isInfoEnabled()) {
                    log.info("Finger print: "+kpair.getFingerPrint());
                }
                kpair.dispose();
            } catch (Exception e) {
                jaxx.runtime.Util.assignment(error=e, "error", fr.ifremer.isisfish.ui.vcs.VCSGenerateSshKeyUI.this);       
                return true;
            }
            return false;
        }
        protected boolean check() {
            jaxx.runtime.Util.assignment(invalidPassPhrase=!Arrays.equals(serverPassPhrase.getPassword(),serverConfirmPassPhrase.getPassword()), "invalidPassPhrase", fr.ifremer.isisfish.ui.vcs.VCSGenerateSshKeyUI.this);
            return !invalidPassPhrase;
        }
    
        protected void doCheck() {
            ok.setEnabled(check());
            setColor(invalidPassPhrase, serverPassPhraseLabel);
            setColor(invalidPassPhrase, serverConfirmPassPhraseLabel);
        }
    
        protected void setColor(boolean invalid, JComponent component) {
            component.setForeground(invalid ? Color.red: Color.black);
        }
    /* end raw body code */
    /*---------------------------------------------------------------------------------*/
    /*-- Statics methods --------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public static jaxx.runtime.JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return jaxx.runtime.Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Constructors -----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public VCSGenerateSshKeyUI() {
        $initialize();
    }

    public VCSGenerateSshKeyUI(jaxx.runtime.JAXXContext parentContext) {
        if (parentContext instanceof jaxx.runtime.JAXXInitialContext) {
            ((jaxx.runtime.JAXXInitialContext)parentContext).to(this);
        } else {
            setContextValue(parentContext);
        }
        $initialize();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXObject implementation ----------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void applyDataBinding(String $binding) {
        processDataBinding($binding);
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    public Map<String,Object> get$objectMap() {
        return $objectMap;
    }

    public java.lang.Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    public void processDataBinding(String dest) {
        processDataBinding(dest, false);
    }

    public void processDataBinding(String $dest, boolean $force) {
        
    }

    public void removeDataBinding(String $binding) {
        
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXContext implementation ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    public jaxx.runtime.JAXXContext getDelegateContext() {
        return delegateContext;
    }

    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return delegateContext.getParentContainer(clazz);
    }

    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return delegateContext.getParentContainer(source, clazz);
    }

    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Event methods ----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void doActionPerformed__on__cancelAction(java.awt.event.ActionEvent event) {
        jaxx.runtime.Util.assignment(cancel = true, "cancel", fr.ifremer.isisfish.ui.vcs.VCSGenerateSshKeyUI.this);dispose();
    }

    public void doActionPerformed__on__ok(java.awt.event.ActionEvent event) {
        jaxx.runtime.Util.assignment(cancel = doGenerate(), "cancel", fr.ifremer.isisfish.ui.vcs.VCSGenerateSshKeyUI.this);dispose();
    }

    public void doKeyReleased__on__serverConfirmPassPhrase(java.awt.event.KeyEvent event) {
        doCheck();
    }

    public void doKeyReleased__on__serverPassPhrase(java.awt.event.KeyEvent event) {
        doCheck();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public acessor methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public java.util.List<Object> get$activeBindings() {
        return $activeBindings;
    }

    public java.util.Map<String,Object> get$bindingSources() {
        return $bindingSources;
    }

    public javax.swing.JButton getCancelAction() {
        return cancelAction;
    }

    public javax.swing.JButton getOk() {
        return ok;
    }

    public javax.swing.JPasswordField getServerConfirmPassPhrase() {
        return serverConfirmPassPhrase;
    }

    public javax.swing.JLabel getServerConfirmPassPhraseLabel() {
        return serverConfirmPassPhraseLabel;
    }

    public javax.swing.JPasswordField getServerPassPhrase() {
        return serverPassPhrase;
    }

    public javax.swing.JLabel getServerPassPhraseLabel() {
        return serverPassPhraseLabel;
    }

    public javax.swing.JTextField getServerPrivateKeyFile() {
        return serverPrivateKeyFile;
    }

    public javax.swing.JTextField getServerPublicKeyFile() {
        return serverPublicKeyFile;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- protected acessors methods ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    protected fr.ifremer.isisfish.ui.vcs.VCSGenerateSshKeyUI get$JDialog0() {
        return $JDialog0;
    }

    protected javax.swing.JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected javax.swing.JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected javax.swing.JPanel get$JPanel4() {
        return $JPanel4;
    }

    protected jaxx.runtime.swing.Table get$Table1() {
        return $Table1;
    }

    protected java.lang.String get$jaxxObjectDescriptor() {
        return $jaxxObjectDescriptor;
    }

    protected java.util.Map get$previousValues() {
        return $previousValues;
    }

    protected boolean getAllComponentsCreated() {
        return allComponentsCreated;
    }

    protected boolean getContextInitialized() {
        return contextInitialized;
    }

    protected Log getLog() {
        return log;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- ui creation methods ----------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        $JDialog0.getContentPane().add($Table1);
        
        $Table1.add($JLabel2, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(serverPrivateKeyFile, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel3, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(serverPublicKeyFile, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(serverPassPhraseLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(serverPassPhrase, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(serverConfirmPassPhraseLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(serverConfirmPassPhrase, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JPanel4, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        
        
        $JPanel4.add(ok);
        $JPanel4.add(cancelAction);
        
        $JDialog0.pack();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$JDialog0", this);
        $Table1 = new jaxx.runtime.swing.Table();
        $objectMap.put("$Table1", $Table1);
        $Table1.setName("$Table1");
        
        $JLabel2 = new javax.swing.JLabel();
        $objectMap.put("$JLabel2", $JLabel2);
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("isisfish.launch.server.ssh.privateKeyFile"));
        
        createServerPrivateKeyFile();
        
        $JLabel3 = new javax.swing.JLabel();
        $objectMap.put("$JLabel3", $JLabel3);
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(_("isisfish.launch.server.ssh.publicKeyFile"));
        
        createServerPublicKeyFile();
        createServerPassPhraseLabel();
        createServerPassPhrase();
        createServerConfirmPassPhraseLabel();
        createServerConfirmPassPhrase();
        
        $JPanel4 = new javax.swing.JPanel();
        $objectMap.put("$JPanel4", $JPanel4);
        $JPanel4.setName("$JPanel4");
        $JPanel4.setLayout((new GridLayout(0, 2, 2, 2)));
        
        createOk();
        createCancelAction();
        $JDialog0.setName("$JDialog0");
        $JDialog0.setModal(true);
        $JDialog0.setTitle(_("isisfish.server.ssh.generateKey.title"));
        
        
        $completeSetup();
    }

    protected void createCancelAction() {
        cancelAction = new javax.swing.JButton();
        $objectMap.put("cancelAction", cancelAction);
        cancelAction.setName("cancelAction");
        cancelAction.setText(_("isisfish.common.cancel"));
        cancelAction.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JDialog0, "doActionPerformed__on__cancelAction"));
    }

    protected void createOk() {
        ok = new javax.swing.JButton();
        $objectMap.put("ok", ok);
        ok.setName("ok");
        ok.setEnabled(false);
        ok.setText(_("isisfish.common.apply"));
        ok.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JDialog0, "doActionPerformed__on__ok"));
    }

    protected void createServerConfirmPassPhrase() {
        serverConfirmPassPhrase = new javax.swing.JPasswordField();
        $objectMap.put("serverConfirmPassPhrase", serverConfirmPassPhrase);
        serverConfirmPassPhrase.setName("serverConfirmPassPhrase");
        serverConfirmPassPhrase.setColumns(15);
        serverConfirmPassPhrase.addKeyListener((java.awt.event.KeyListener) jaxx.runtime.Util.getEventListener(java.awt.event.KeyListener.class, "keyReleased", $JDialog0, "doKeyReleased__on__serverConfirmPassPhrase"));
    }

    protected void createServerConfirmPassPhraseLabel() {
        serverConfirmPassPhraseLabel = new javax.swing.JLabel();
        $objectMap.put("serverConfirmPassPhraseLabel", serverConfirmPassPhraseLabel);
        serverConfirmPassPhraseLabel.setName("serverConfirmPassPhraseLabel");
        serverConfirmPassPhraseLabel.setText(_("isisfish.launch.server.ssh.confirm.passphrase"));
    }

    protected void createServerPassPhrase() {
        serverPassPhrase = new javax.swing.JPasswordField();
        $objectMap.put("serverPassPhrase", serverPassPhrase);
        serverPassPhrase.setName("serverPassPhrase");
        serverPassPhrase.setColumns(15);
        serverPassPhrase.addKeyListener((java.awt.event.KeyListener) jaxx.runtime.Util.getEventListener(java.awt.event.KeyListener.class, "keyReleased", $JDialog0, "doKeyReleased__on__serverPassPhrase"));
    }

    protected void createServerPassPhraseLabel() {
        serverPassPhraseLabel = new javax.swing.JLabel();
        $objectMap.put("serverPassPhraseLabel", serverPassPhraseLabel);
        serverPassPhraseLabel.setName("serverPassPhraseLabel");
        serverPassPhraseLabel.setText(_("isisfish.launch.server.ssh.passphrase"));
    }

    protected void createServerPrivateKeyFile() {
        serverPrivateKeyFile = new javax.swing.JTextField();
        $objectMap.put("serverPrivateKeyFile", serverPrivateKeyFile);
        serverPrivateKeyFile.setName("serverPrivateKeyFile");
        serverPrivateKeyFile.setColumns(15);
        serverPrivateKeyFile.setColumns(28);
        serverPrivateKeyFile.setEditable(false);
        if (serverPrivateKeyFile.getFont() != null) serverPrivateKeyFile.setFont(serverPrivateKeyFile.getFont().deriveFont((float) 12));
        jaxx.runtime.Util.setComponentHeight(serverPrivateKeyFile,25);
    }

    protected void createServerPublicKeyFile() {
        serverPublicKeyFile = new javax.swing.JTextField();
        $objectMap.put("serverPublicKeyFile", serverPublicKeyFile);
        serverPublicKeyFile.setName("serverPublicKeyFile");
        serverPublicKeyFile.setColumns(15);
        serverPublicKeyFile.setColumns(28);
        serverPublicKeyFile.setEditable(false);
        if (serverPublicKeyFile.getFont() != null) serverPublicKeyFile.setFont(serverPublicKeyFile.getFont().deriveFont((float) 12));
        jaxx.runtime.Util.setComponentHeight(serverPublicKeyFile,25);
    }

}
