package fr.ifremer.isisfish.ui.util;

import jaxx.runtime.JAXXObject;

import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import java.util.Map;

/** some util generic algorithm  for jaxx objects */
public class JaxxUtil {

    @SuppressWarnings({"unchecked"})
    public static void doReset(Map<String, ?> $objectMap) {

        if ($objectMap == null) return;

        for (Map.Entry<String, ?> o : $objectMap.entrySet()) {
            Class aClass = o.getValue().getClass();
            Object val = o.getValue();
            if (JTextField.class.isAssignableFrom(aClass))
                ((JTextField) val).setText("");
            else if (JCheckBox.class.isAssignableFrom(aClass))
                ((JCheckBox) val).setSelected(false);
            else if (JComboBox.class.isAssignableFrom(aClass))
                ((JComboBox) val).setSelectedIndex(-1);
        }
    }

    /**
     * Refresh dialog and process data binding for given keys
     *
     * @param dial     jaxx dialog
     * @param keyFirst first to refresh
     * @param keys     keys to refresh
     */
    public static void refresh(JAXXObject dial, String keyFirst, String... keys) {
        if (!IDialog.class.isAssignableFrom(dial.getClass())) return;

        IDialog dialog = (IDialog) dial;
        dialog.getOk().setEnabled(dialog.isOkEnabled());
        dial.processDataBinding(keyFirst);
        for (String key : keys) dial.processDataBinding(key);
        dialog.repaint();
    }
}

