package fr.ifremer.isisfish.ui.util;

import javax.swing.AbstractAction;
import javax.swing.JDialog;
import java.awt.event.ActionEvent;

public abstract class IsisAction extends AbstractAction {
    /**
     * flag to say if something has been done in this action (is init in
     * {@link #prepare()} method)
     */
    protected boolean used;
    /**
     * dialog source of the action (of <code>null</code> if none)
     */
    protected JDialog dialog;

    private static final long serialVersionUID = -968662451138199001L;

    protected IsisAction() {
        this(null);
    }

    protected IsisAction(JDialog dialog) {
        super();
        this.dialog = dialog;
    }


    public void actionPerformed(ActionEvent e) {

        try {
            // just prepare action and set used field value
            used = prepare();

            // perform action if there is something to do
            if (used) perform(e);
        } finally {
            //TODO Fix lock between few dialog
            // after action perfored
            finish();
        }
    }
    /**
     * Prepare data for action, and find out if there is really something to
     * do here.
     *
     * @return <code>true</code> if there is something to do here,
     *         <code>false</code> otherwise
     */
    protected abstract boolean prepare();

    /**
     * perform safelly action after {@link #prepare()} was invoked
     * This method is only called if used was <code>true</code>
     *
     * @param e event source
     */
    protected abstract void perform(ActionEvent e);

    /**
     * called inside {@link #actionPerformed(java.awt.event.ActionEvent)} after
     * {@link #perform(java.awt.event.ActionEvent)} was invoked (so can't
     * be come here is nothing was to be done in this action.
     */
    protected void finish() {
        if (dialog != null && needDispose()) dialog.dispose();
    }

    /**
     * @return <code>true</code> if we have to dispose dialog,
     *         <code>false</code> otherwise
     */
    protected boolean needDispose() {
        return used;
    }

    /**
     * @return <code>true</code> if something was done in the action performed,
     *         <code>false</code> otherwise
     */
    public boolean isUsed() {
        return used;
    }
}
