package fr.ifremer.isisfish.ui.util;

import javax.swing.AbstractAction;
import javax.swing.JButton;
import java.awt.Dimension;

public interface IDialog {
    /**
     * @return the ok button (jaxx generated)
     */
    JButton getOk();

    /**
     * @return the cancel button (jaxx generated)
     */
    JButton getCancel();

    /**
     * to doRefresh dialog (use processDataBinding)
     */
    void doRefresh();

    /**
     * @return <code>true</code> if ok button is enabled, <code>false</code>
     *         otherwise
     */
    boolean isOkEnabled();

    /**
     * @return <code>true</code> if dialog has no data, <code>false</code>
     *         otherwise
     */
    boolean isEmpty();

    int computeWidth();

    int computeHeight();

    // ------------------ JDialog methods
    void setVisible(boolean b);

    void setSize(int width, int height);

    void setMaximumSize(Dimension dimension);

    void setOkAction(AbstractAction okAction);

    void setCancelAction(AbstractAction cancelAction);

    void setMaxWidth(int maxWidth);

    void setMinHeight(int minHeight);

    void setMaxHeight(int maxHeight);

    void repaint();

    void setTitle(String s);
}
