/* *##%
 * Copyright (C) 2009 Code Lutin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *##%*/

package fr.ifremer.isisfish.ui.util;

import static org.nuiton.i18n.I18n._;

import java.awt.Component;

import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.error.ErrorInfo;

/**
 * Error helper.
 * 
 * @author chatellier
 * @version $Revision: 2688 $
 * 
 * Last update : $Date: 2009-10-26 15:55:36 +0100 (lun., 26 oct. 2009) $
 * By : $Author$
 */
public class ErrorHelper {

    /**
     * Display a user friendly error frame.
     * 
     * @param parent parent component
     * @param message message for user
     * @param cause exception cause
     */
    public static void showErrorDialog(Component parent, String message,
            Throwable cause) {

        ErrorInfo info = new ErrorInfo(_("isisfish.error.errorpane.title"),
                _("isisfish.error.errorpane.htmlmessage", message), null, null,
                cause, null, null);
        JXErrorPane.showDialog(parent, info);
    }

    /**
     * Display a user friendly error frame.
     * 
     * @param message message for user
     */
    public static void showErrorDialog(String message) {
        showErrorDialog(message, null);
    }

    /**
     * Display a user friendly error frame.
     * 
     * @param message message for user
     * @param cause exception cause
     */
    public static void showErrorDialog(String message, Throwable cause) {
        showErrorDialog(null, message, cause);
    }
}
