/* *##%
 *  Copyright (C) 2002-2009 Ifremer, Code Lutin, Benjamin Poussin
 * 
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 *  USA.
 * ##%*/

package fr.ifremer.isisfish.ui.sensitivity;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * Utility class to parse Sensitivity properties file.
 * 
 * @author letellier
 * @version $Revision: 2857 $
 *
 * Last update: $Date: 2009-12-21 16:08:40 +0100 (lun., 21 déc. 2009) $
 * by : $Author: chatellier $
 */
public class SensitivityUtils {

    /** Log. */
    private static final Log log = LogFactory.getLog(SensitivityUtils.class);

    /** Properties file resource path. */
    protected final static String PROPERTIES_PATH = "/sensitivity.properties";

    /** Cached properties. */
    protected static Properties sensitivityProperties;

    /**
     * Is field sensitivity enabled.
     * 
     * Return true, if field name is present in properties file.
     * 
     * @param sensitivityFactorName name
     * @return <tt>true</tt> if factor name is sensitivity enabled
     */
    public static boolean isSensitivityFactorEnabled(String sensitivityFactorName) {
        Properties data = getProperties();
        return data.getProperty(sensitivityFactorName) != null;

    }

    /**
     * Return cached properties file.
     * Load it at first call.
     * 
     * @return properties
     */
    public static Properties getProperties() {

        if (sensitivityProperties == null) {
            sensitivityProperties = new Properties();
            InputStream stream = null;
            try {
                stream = SensitivityUtils.class.getResourceAsStream(PROPERTIES_PATH);
                sensitivityProperties.load(stream);
            } catch (IOException ex) {
                if (log.isErrorEnabled()) {
                    log.error("Can't load sensitivity properties file", ex);
                }
            } finally {
                try {
                    if (stream != null) {
                        stream.close();
                    }
                } catch (IOException ex) {
                    if (log.isErrorEnabled()) {
                        log.error("Can't load sensitivity properties file", ex);
                    }
                }
            }
        }
        return sensitivityProperties;
    }
}
