/* *##%
 * Copyright (C) 2010 Ifremer, Code Lutin, Chatellier Eric
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *##%*/

package fr.ifremer.isisfish.ui.sensitivity;

import javax.swing.table.TableModel;

/**
 * Sensitivity interface for {@link TableModel}.
 * 
 * Used by {@link TableBlockingLayerUI} to known if event at mouse position
 * is sensitivity enabled.
 * 
 * @author chatellier
 * @version $Revision: 2937 $
 * 
 * Last update : $Date: 2010-01-22 16:39:11 +0100 (ven., 22 janv. 2010) $
 * By : $Author$
 */
public interface SensitivityTableModel {

    /**
     * Get value at row.
     * 
     * @param rowIndex row index
     * @return value at row/column
     */
    Object getBeanAtRow(int rowIndex);
    
    /**
     * Get property name at column.
     * 
     * @param column column
     * @return property name at column (can be {@code null})
     */
    String getPropertyAtColumn(int column);
}