/* *##%
 * Copyright (C) 2009-2010 Ifremer, Code Lutin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *##%*/

package fr.ifremer.isisfish.ui.sensitivity;

import fr.ifremer.isisfish.ui.input.InputContentUI;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * Sensitivity change listener to control tab swapping.
 * 
 * @author letellier
 * @version $Revision: 2886 $
 * 
 * Last update : $Date: 2010-01-08 10:35:05 +0100 (ven., 08 janv. 2010) $
 * By : $Author: chatellier $
 */
public class SensitivityTabbedPaneListener implements ChangeListener {

    /** Class logger. */
    private static Log log = LogFactory.getLog(SensitivityTabbedPaneListener.class);

    protected int cacheSelectedIndex = -1;

    @Override
    public void stateChanged(ChangeEvent e) {
        try {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            pane.removeChangeListener(this);
            int selectedIndex = pane.getSelectedIndex();
            if (cacheSelectedIndex != -1){
                pane.setSelectedIndex(cacheSelectedIndex);
            }
            if (InputContentUI.class.isInstance(pane.getSelectedComponent())){
                InputContentUI ui = (InputContentUI) pane.getSelectedComponent();
                if (closeUI(ui)) {
                    pane.setSelectedIndex(selectedIndex);
                }
                if (InputContentUI.class.isInstance(pane.getSelectedComponent())){
                    ui = (InputContentUI) pane.getSelectedComponent();
                    ui.setSensitivity(true);
                    ui.setLayer(true);
                    // otherwise save.cancel buttons are active in last
                    // refreshed ui
                    ui.setActionButtons();
                    ui.refresh();
                    cacheSelectedIndex = pane.getSelectedIndex();
                    pane.addChangeListener(this);
                    
                    // bug suis les UI autre que nimbus
                    // la selection des onglet ne se rafraichit pas tres bien
                    pane.repaint();
                }
            }
        } catch (Exception ex) {
            log.error(ex);
        }
    }

    /**
     * Ask you to save if modification are made.
     * 
     * @param context selected
     * @return true to change tab
     */
    protected boolean closeUI(InputContentUI context) throws Exception {
        boolean exit = true;
        return exit;
    }
}
