package fr.ifremer.isisfish.ui.sensitivity;

import fr.ifremer.isisfish.ui.sensitivity.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.Table;
import static org.nuiton.i18n.I18n._;
import static jaxx.runtime.Util.createImageIcon;
import jaxx.runtime.SwingUtil;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import fr.ifremer.isisfish.ui.simulator.SimulAction;
import fr.ifremer.isisfish.simulator.sensitivity.Domain;
import fr.ifremer.isisfish.simulator.sensitivity.Factor;
import fr.ifremer.isisfish.simulator.sensitivity.SensitivityCalculator;
import fr.ifremer.isisfish.simulator.sensitivity.domain.ContinuousDomain;
import fr.ifremer.isisfish.export.SensitivityExport;
import fr.ifremer.isisfish.ui.models.sensitivityexport.SensitivityExportListModel;
import fr.ifremer.isisfish.ui.models.sensitivityexport.SensitivityExportListRenderer;
import fr.ifremer.isisfish.ui.models.sensitivityexport.SensitivityExportNameListModel;
import fr.ifremer.isisfish.ui.models.sensitivityexport.SensitivityExportNameListRenderer;
import fr.ifremer.isisfish.ui.models.sensitivityexport.SensitivityExportParametersTableCellEditor;
import fr.ifremer.isisfish.ui.models.sensitivityexport.SensitivityExportParametersTableCellRenderer;
import fr.ifremer.isisfish.ui.models.sensitivityexport.SensitivityExportParametersTableModel;
import fr.ifremer.isisfish.ui.models.sensitivity.SensitivityCalculatorComboModel;
import fr.ifremer.isisfish.ui.models.sensitivity.SensitivityCalculatorComboRenderer;
import fr.ifremer.isisfish.ui.models.sensitivity.SensitivityCalculatorListModel;
import fr.ifremer.isisfish.ui.models.sensitivity.SensitivityCalculatorListRenderer;
import fr.ifremer.isisfish.ui.models.sensitivity.SensitivityCalculatorParametersTableCellEditor;
import fr.ifremer.isisfish.ui.models.sensitivity.SensitivityCalculatorParametersTableCellRenderer;
import fr.ifremer.isisfish.ui.models.sensitivity.SensitivityCalculatorParametersTableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SensitivityChooserUI extends jaxx.runtime.swing.Table implements jaxx.runtime.JAXXObject {
    public static final Log log = LogFactory.getLog(fr.ifremer.isisfish.ui.sensitivity.SensitivityChooserUI.class);
    private static java.lang.String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKWVz28TRxTHJy6OEyAQnJQfDT9MGyqBqnULlKAm4kcMEaROizBICF8Ye8fxoPHOMDPrLJeqUq9VxamHXmjvHLkjxJETV/4HhPgPeDO72fUmG2dV57C23773me97M/PNiw+oqCQ6/RgHgSN9T9MecVavP3jwa+sxaesbRLUlFZpLFP6NFVChifa5cVxp9E2zbsqrUXm1xnuCe8QbqF6so71KP2VEdQnRGn0ZVrSVqjbi8GIgfLlJi8Vk0f799LHwzP39vwJCgQBVM9BCZbeqpIM9dVSgrkZlWKmPqwx76yBDUm8ddE6ZWI1hpX7BPfIE/YZKdTQusASYRl/nb9UybH0gNCrN38MtRr7XaKEjHdqRpEfgU1HVoarr+NRRxFNU0z7VT51G8r3W5VwRef+2EJY2rtHE/Godtwj7AVowagNHbYB4J4yapMk4t9KhhLmDPMzaPsOgtEEYbLFGp1KTi1BwBKC5Fl/mQRo4Nb/aaEvO2B3skfMaHUkpSF6lq04p2vNZpow7WOLe1k7ssExtOUbMdXAb0mtYutTDDBjpxWbTKx7alm5eHDGPo9smecH8PpAGRDt2UaOjGQOKBe4wmR9jSSeTDqBDykzhwCBuBoJLDddobodtqFOlDeD0VmWXzM9KeomD2HVD4rKvNfc0mknNNYya5G/jmjKcRd4ng2XmzbktWW1GsIzU7piVmsFCxgy+UvbUEXf7CEzGGfOoZuMuZ+0ysbX2DKl4T+wuXxDgCjN2qOAzTuIziRGMNVFR+hDWaLqZWNJdCIVmFEUtwEaf//FP/++Xr37adJ4yrDGVShkwSnACIbkgUlOzxMHQbnxNWXUNi8UmmgyHYV10dkBAIwqDCOAfMmWOKXNuYdWF0mLp/es3hx+9+wIVVtBexrG7Yg/7bTSpuxK65MwNxNVrVsn+jQl4ThtNGu3RJIArX16iHqMeqWANvtfyNbkSQLuzA+3GGt4++3Pt+F8nFjZbHgslbUlL2i4+ROMh3dps5KCZtrpPKOK7PHHKLO8cM59TIrK/Jfu8ltVbscddwjQ6sORijSst6sHNX4fGTMUNq9x8W7HA6RzACfB8l0giTcbP/58zKfnGLULXu/Ye17JBh3OASn34hxGd8R0wx3bFmPD9IYS5XITlIYQTOVrZ3yaM3d19vvO51KyORACfCS8i5d4anKERYSXiGSNyh0zo7MgzzkfwhxC+G1lDPsIwDc7IGvIRxJAtPT/yjbkEhM+vppgBSQsAAA==";
    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected java.util.Map<String,Object> $bindingSources = new HashMap<String,Object>();
    protected Map<String,Object> $objectMap = new HashMap<String,Object>();
    protected javax.swing.JButton addExportButton;
    protected jaxx.runtime.swing.JAXXList availableSensitivityExports;
    protected javax.swing.JButton clearExportsButton;
    protected final jaxx.runtime.JAXXContext delegateContext = new jaxx.runtime.DefaultJAXXContext(this);;
    protected javax.swing.JTable exportParamsTable;
    protected javax.swing.JTable factorCardinality;
    protected javax.swing.JScrollPane factorCardinalityScrollPane;
    protected jaxx.runtime.swing.JAXXComboBox fieldSensitivityCalculatorSelect;
    protected javax.swing.JButton removeExportButton;
    protected jaxx.runtime.swing.JAXXList selectedSensitivityExports;
    protected javax.swing.JTable simulSensitivityCalculatorParam;
    private javax.swing.JLabel $JLabel1;
    private javax.swing.JLabel $JLabel3;
    private javax.swing.JScrollPane $JScrollPane2;
    private javax.swing.JScrollPane $JScrollPane5;
    private javax.swing.JScrollPane $JScrollPane7;
    private javax.swing.JScrollPane $JScrollPane8;
    private fr.ifremer.isisfish.ui.sensitivity.SensitivityChooserUI $Table0 = this;
    private jaxx.runtime.swing.Table $Table4;
    private jaxx.runtime.swing.Table $Table6;
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    java.util.Map $previousValues = new java.util.HashMap();
    private java.beans.PropertyChangeListener $DataSource12 = new jaxx.runtime.DataBindingListener($Table0, "availableSensitivityExports.model");
    private java.beans.PropertyChangeListener $DataSource9 = new jaxx.runtime.DataBindingListener($Table0, "fieldSensitivityCalculatorSelect.model");

    /* begin raw body code */    
    
        protected SimulAction getSimulAction() {
            return getContextValue(SimulAction.class);
        }
    
        public ComboBoxModel getSensitivityCalculatorModel() {
            java.util.List<String> sensitivityNames = getSimulAction().getSensitivityNames();
            SensitivityCalculatorComboModel model = new SensitivityCalculatorComboModel(sensitivityNames);
            return model;
        }
    
        /**
         * Auto select calculator in JComboBox
         * with calculator selected in SimulAction.
         *
         * Used by "reloadOldSimulation" operation.
         */
        public void refreshSelectedSensitivityCalculator() {
            SensitivityCalculator calculator = getSimulAction().getSensitivityCalculator();
            if (calculator != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Refreshing calculator list");
                }
                // TODO it's not getSimpleName() here !
                fieldSensitivityCalculatorSelect.setSelectedItem(calculator.getClass().getSimpleName());
            }
        }
        
        protected void sensCalculatorChanged() {
        
            // TODO change combo box content
            // when calculator is changed by refreshSelectedSensitivityCalculator
            // this event is thrown by build a new Calculator instance
            // and parameter are lost
            
            String sensitivityName = (String)fieldSensitivityCalculatorSelect.getSelectedItem();
            SensitivityCalculator sensivitityCalculator = getSimulAction().getSensivitityCalculatorInstance(sensitivityName);
            
            // can be null for example if calculator can't be compiled
            if (sensivitityCalculator != null) {
                getSimulAction().setSensitivityCalculator(sensivitityCalculator);
                    
                // enable/disable table (if sensivitityCalculator can manage it)
                factorCardinalityScrollPane.setVisible(!sensivitityCalculator.canManageCardinality());
                validate();
    
                // update model
                //setSensitivityCalculatorParamsModel();
                SensitivityCalculatorParametersTableModel parametersTableModel = new SensitivityCalculatorParametersTableModel(sensivitityCalculator);
                simulSensitivityCalculatorParam.setModel(parametersTableModel);
                simulSensitivityCalculatorParam.getColumnModel().getColumn(0).setCellRenderer(new SensitivityCalculatorParametersTableCellRenderer(sensivitityCalculator));
                simulSensitivityCalculatorParam.getColumnModel().getColumn(1).setCellEditor(new SensitivityCalculatorParametersTableCellEditor(sensivitityCalculator));
            }
        }
    
        public void setFactorCardinalityTableModel() {
            DefaultTableModel model = new DefaultTableModel() {
                @Override
                public boolean isCellEditable(int row, int column) {
                    boolean result = false;
                    if (column > 0) {
                        result = true;
                    }
                    return result;
                }
            };
            java.util.List<Factor<?, ?>> factors = getSimulAction().getFactors();
    
        	java.util.List<Factor<?, ?>> factorsContinue = new ArrayList<Factor<?, ?>>();
        	java.util.List<String> factorsContinueCardinalities = new ArrayList<String>();
            for (Factor<?, ?> f : factors) {
                Domain domain = f.getDomain();
                if (ContinuousDomain.class.isInstance(domain)) {
                    ContinuousDomain continuousDomain = (ContinuousDomain)domain;
                    factorsContinue.add(f);
                    factorsContinueCardinalities.add(continuousDomain.getCardinality() + "");
                }
            }
            model.addColumn(_("isisfish.sensitivity.factor"), factorsContinue.toArray());
            model.addColumn(_("isisfish.sensitivity.increment"), factorsContinueCardinalities.toArray());
    
            factorCardinality.setModel(model);
            factorCardinality.getModel().addTableModelListener(new TableModelListener() {
                @Override
                public void tableChanged(TableModelEvent e) {
                    int row = e.getFirstRow();
                    TableModel model = (TableModel)e.getSource();
                    Factor f = (Factor) model.getValueAt(row, 0);
                    ((ContinuousDomain)f.getDomain()).setCardinality(Integer.parseInt((String)model.getValueAt(row, 1)));
                }
            });
        }
    
        protected SensitivityExportNameListModel getAvailableExportListModel() {
            java.util.List<String> exportNames = getSimulAction().getSensitivityExportNames();
            SensitivityExportNameListModel model = new SensitivityExportNameListModel(exportNames);
            return model;
        }
        
        /**
         * Add multiples export.
         *
         * Export name can be duplicated.
         */
        protected void addExports() {
            Object[] exportNames = (Object[])availableSensitivityExports.getSelectedValues();
            for (Object exportName : exportNames) {
                getSimulAction().addSensitivityExport((String)exportName);
            }
            setSensitivityExportListModel();
        }
        
        /**
         * Remove multiple export.
         */
        protected void removeExports() {
            Object[] exports = (Object[])selectedSensitivityExports.getSelectedValues();
            for (Object export : exports) {
                getSimulAction().removeSensitivityExport((SensitivityExport)export);
            }
            setSensitivityExportListModel();
        }
        
        /**
         * Clear all export.
         */
        protected void clearExports() {
            getSimulAction().clearSensitivityExport();
            setSensitivityExportListModel();
        }
        
        /**
         * Set model (refresh export JList).
         */
        public void setSensitivityExportListModel() {
            java.util.List<SensitivityExport> exports = getSimulAction().getSensitivityExports();
            SensitivityExportListModel model = new SensitivityExportListModel(exports);
            selectedSensitivityExports.setModel(model);
            selectedSensitivityExports.setCellRenderer(new SensitivityExportListRenderer());
    
            clearExportsButton.setEnabled(!exports.isEmpty());
        }
    
        /**
         * When selection change on available export list.
         */
        protected void availableSensitivityExportSelection() {
            addExportButton.setEnabled(availableSensitivityExports.getSelectedIndices().length != 0);
        }
        
        /**
         * When selection change on choosen export list.
         */
        protected void selectedSensitivityExportSelection() {
            if (log.isDebugEnabled()) {
                log.debug("Sensitivity export selection change"); 
            }
            setExportParams();
            removeExportButton.setEnabled(selectedSensitivityExports.getSelectedIndices().length != 0);
        }
        
        /**
         * Fill export parameters names and values in table.
         */ 
        protected void setExportParams() {
            SimulAction simulAction = getContextValue(SimulAction.class);
    
            if (selectedSensitivityExports.getSelectedIndices().length == 1) {
                SensitivityExport export = (SensitivityExport)selectedSensitivityExports.getSelectedValue();
                SensitivityExportParametersTableModel model = new SensitivityExportParametersTableModel(export);
                exportParamsTable.setModel(model);
                exportParamsTable.getColumnModel().getColumn(0).setCellRenderer(new SensitivityExportParametersTableCellRenderer(export));
                SensitivityExportParametersTableCellEditor cellEditor = new SensitivityExportParametersTableCellEditor(export);
                cellEditor.setRegion(simulAction.getRegionStorage());
                exportParamsTable.getColumnModel().getColumn(1).setCellEditor(cellEditor);
            }
            else {
                exportParamsTable.setModel(new DefaultTableModel());
            }
        }
    /* end raw body code */
    /*---------------------------------------------------------------------------------*/
    /*-- Statics methods --------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public static jaxx.runtime.JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return jaxx.runtime.Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Constructors -----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public SensitivityChooserUI() {
        $initialize();
    }

    public SensitivityChooserUI(jaxx.runtime.JAXXContext parentContext) {
        if (parentContext instanceof jaxx.runtime.JAXXInitialContext) {
            ((jaxx.runtime.JAXXInitialContext)parentContext).to(this);
        } else {
            setContextValue(parentContext);
        }
        $initialize();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXObject implementation ----------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void applyDataBinding(String $binding) {
        if ("fieldSensitivityCalculatorSelect.model".equals($binding)) {
                addPropertyChangeListener("sensitivityCalculatorModel", $DataSource9);
        
        } else if ("availableSensitivityExports.model".equals($binding)) {
                addPropertyChangeListener("availableExportListModel", $DataSource12);
        
        }
        processDataBinding($binding);
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    public Map<String,Object> get$objectMap() {
        return $objectMap;
    }

    public java.lang.Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    public void processDataBinding(String dest) {
        processDataBinding(dest, false);
    }

    public void processDataBinding(String $dest, boolean $force) {
        if (!$force && $activeBindings.contains($dest)) { 
            return;
        }
        $activeBindings.add($dest);
        try {
            if ("fieldSensitivityCalculatorSelect.model".equals($dest)) {
            fieldSensitivityCalculatorSelect.setModel((getSensitivityCalculatorModel()));
            } else if ("availableSensitivityExports.model".equals($dest)) {
            availableSensitivityExports.setModel((getAvailableExportListModel()));
            }} finally {
            $activeBindings.remove($dest);
        }
    }

    public void removeDataBinding(String $binding) {
        if ("fieldSensitivityCalculatorSelect.model".equals($binding)) {
                removePropertyChangeListener("sensitivityCalculatorModel", $DataSource9);
        
        } else if ("availableSensitivityExports.model".equals($binding)) {
                removePropertyChangeListener("availableExportListModel", $DataSource12);
        
        }
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXContext implementation ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    public jaxx.runtime.JAXXContext getDelegateContext() {
        return delegateContext;
    }

    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return delegateContext.getParentContainer(clazz);
    }

    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return delegateContext.getParentContainer(source, clazz);
    }

    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Event methods ----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void doActionPerformed__on__addExportButton(java.awt.event.ActionEvent event) {
        addExports();
    }

    public void doActionPerformed__on__clearExportsButton(java.awt.event.ActionEvent event) {
        clearExports();
    }

    public void doActionPerformed__on__fieldSensitivityCalculatorSelect(java.awt.event.ActionEvent event) {
        sensCalculatorChanged();
    }

    public void doActionPerformed__on__removeExportButton(java.awt.event.ActionEvent event) {
        removeExports();
    }

    public void doValueChanged__on__availableSensitivityExports(javax.swing.event.ListSelectionEvent event) {
        availableSensitivityExportSelection();
    }

    public void doValueChanged__on__selectedSensitivityExports(javax.swing.event.ListSelectionEvent event) {
        selectedSensitivityExportSelection();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public acessor methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public java.util.List<Object> get$activeBindings() {
        return $activeBindings;
    }

    public java.util.Map<String,Object> get$bindingSources() {
        return $bindingSources;
    }

    public javax.swing.JButton getAddExportButton() {
        return addExportButton;
    }

    public jaxx.runtime.swing.JAXXList getAvailableSensitivityExports() {
        return availableSensitivityExports;
    }

    public javax.swing.JButton getClearExportsButton() {
        return clearExportsButton;
    }

    public javax.swing.JTable getExportParamsTable() {
        return exportParamsTable;
    }

    public javax.swing.JTable getFactorCardinality() {
        return factorCardinality;
    }

    public javax.swing.JScrollPane getFactorCardinalityScrollPane() {
        return factorCardinalityScrollPane;
    }

    public jaxx.runtime.swing.JAXXComboBox getFieldSensitivityCalculatorSelect() {
        return fieldSensitivityCalculatorSelect;
    }

    public javax.swing.JButton getRemoveExportButton() {
        return removeExportButton;
    }

    public jaxx.runtime.swing.JAXXList getSelectedSensitivityExports() {
        return selectedSensitivityExports;
    }

    public javax.swing.JTable getSimulSensitivityCalculatorParam() {
        return simulSensitivityCalculatorParam;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- protected acessors methods ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected javax.swing.JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected javax.swing.JScrollPane get$JScrollPane2() {
        return $JScrollPane2;
    }

    protected javax.swing.JScrollPane get$JScrollPane5() {
        return $JScrollPane5;
    }

    protected javax.swing.JScrollPane get$JScrollPane7() {
        return $JScrollPane7;
    }

    protected javax.swing.JScrollPane get$JScrollPane8() {
        return $JScrollPane8;
    }

    protected fr.ifremer.isisfish.ui.sensitivity.SensitivityChooserUI get$Table0() {
        return $Table0;
    }

    protected jaxx.runtime.swing.Table get$Table4() {
        return $Table4;
    }

    protected jaxx.runtime.swing.Table get$Table6() {
        return $Table6;
    }

    protected java.lang.String get$jaxxObjectDescriptor() {
        return $jaxxObjectDescriptor;
    }

    protected java.util.Map get$previousValues() {
        return $previousValues;
    }

    protected boolean getAllComponentsCreated() {
        return allComponentsCreated;
    }

    protected boolean getContextInitialized() {
        return contextInitialized;
    }

    protected Log getLog() {
        return log;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- ui creation methods ----------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        $Table0.add($JLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(fieldSensitivityCalculatorSelect, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JScrollPane2, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(factorCardinalityScrollPane, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel3, new GridBagConstraints(0, 3, 3, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($Table4, new GridBagConstraints(0, 4, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JScrollPane8, new GridBagConstraints(0, 5, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        
        
        $JScrollPane2.getViewport().add(simulSensitivityCalculatorParam);
        
        addChildrenToFactorCardinalityScrollPane();
        
        $Table4.add($JScrollPane5, new GridBagConstraints(0, 0, 1, 1, 0.5, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table4.add($Table6, new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table4.add($JScrollPane7, new GridBagConstraints(2, 0, 1, 1, 0.5, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        
        $JScrollPane5.getViewport().add(availableSensitivityExports);
        
        $Table6.add(addExportButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table6.add(removeExportButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table6.add(clearExportsButton, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        
        $JScrollPane7.getViewport().add(selectedSensitivityExports);
        
        $JScrollPane8.getViewport().add(exportParamsTable);
        
        applyDataBinding("fieldSensitivityCalculatorSelect.model");
        fieldSensitivityCalculatorSelect.setRenderer((new SensitivityCalculatorComboRenderer()));
        availableSensitivityExports.setCellRenderer((new SensitivityExportNameListRenderer()));
        applyDataBinding("availableSensitivityExports.model");
        availableSensitivityExports.setSelectionMode((javax.swing.ListSelectionModel.MULTIPLE_INTERVAL_SELECTION));
        selectedSensitivityExports.setSelectionMode((javax.swing.ListSelectionModel.MULTIPLE_INTERVAL_SELECTION));
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$Table0", this);
        $JLabel1 = new javax.swing.JLabel();
        $objectMap.put("$JLabel1", $JLabel1);
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("isisfish.sensitivity.select"));
        
        createFieldSensitivityCalculatorSelect();
        
        $JScrollPane2 = new javax.swing.JScrollPane();
        $objectMap.put("$JScrollPane2", $JScrollPane2);
        $JScrollPane2.setName("$JScrollPane2");
        
        createSimulSensitivityCalculatorParam();
        createFactorCardinalityScrollPane();
        createFactorCardinality();
        
        $JLabel3 = new javax.swing.JLabel();
        $objectMap.put("$JLabel3", $JLabel3);
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(_("isisfish.sensitivity.export"));
        
        $Table4 = new jaxx.runtime.swing.Table();
        $objectMap.put("$Table4", $Table4);
        $Table4.setName("$Table4");
        
        $JScrollPane5 = new javax.swing.JScrollPane();
        $objectMap.put("$JScrollPane5", $JScrollPane5);
        $JScrollPane5.setName("$JScrollPane5");
        
        createAvailableSensitivityExports();
        
        $Table6 = new jaxx.runtime.swing.Table();
        $objectMap.put("$Table6", $Table6);
        $Table6.setName("$Table6");
        
        createAddExportButton();
        createRemoveExportButton();
        createClearExportsButton();
        
        $JScrollPane7 = new javax.swing.JScrollPane();
        $objectMap.put("$JScrollPane7", $JScrollPane7);
        $JScrollPane7.setName("$JScrollPane7");
        
        createSelectedSensitivityExports();
        
        $JScrollPane8 = new javax.swing.JScrollPane();
        $objectMap.put("$JScrollPane8", $JScrollPane8);
        $JScrollPane8.setName("$JScrollPane8");
        
        createExportParamsTable();
        $Table0.setName("$Table0");
        
        
        $completeSetup();
    }

    protected void addChildrenToFactorCardinalityScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        factorCardinalityScrollPane.getViewport().add(factorCardinality);
    }

    protected void createAddExportButton() {
        addExportButton = new javax.swing.JButton();
        $objectMap.put("addExportButton", addExportButton);
        addExportButton.setName("addExportButton");
        addExportButton.setEnabled(false);
        addExportButton.setText(_("isisfish.common.add"));
        addExportButton.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $Table0, "doActionPerformed__on__addExportButton"));
    }

    protected void createAvailableSensitivityExports() {
        availableSensitivityExports = new jaxx.runtime.swing.JAXXList();
        $objectMap.put("availableSensitivityExports", availableSensitivityExports);
        availableSensitivityExports.setName("availableSensitivityExports");
        availableSensitivityExports.addListSelectionListener((javax.swing.event.ListSelectionListener) jaxx.runtime.Util.getEventListener(javax.swing.event.ListSelectionListener.class, "valueChanged", $Table0, "doValueChanged__on__availableSensitivityExports"));
    }

    protected void createClearExportsButton() {
        clearExportsButton = new javax.swing.JButton();
        $objectMap.put("clearExportsButton", clearExportsButton);
        clearExportsButton.setName("clearExportsButton");
        clearExportsButton.setEnabled(false);
        clearExportsButton.setText(_("isisfish.common.clear"));
        clearExportsButton.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $Table0, "doActionPerformed__on__clearExportsButton"));
    }

    protected void createExportParamsTable() {
        exportParamsTable = new javax.swing.JTable();
        $objectMap.put("exportParamsTable", exportParamsTable);
        exportParamsTable.setName("exportParamsTable");
        exportParamsTable.setRowHeight(24);
    }

    protected void createFactorCardinality() {
        factorCardinality = new javax.swing.JTable();
        $objectMap.put("factorCardinality", factorCardinality);
        factorCardinality.setName("factorCardinality");
        factorCardinality.setRowHeight(24);
    }

    protected void createFactorCardinalityScrollPane() {
        factorCardinalityScrollPane = new javax.swing.JScrollPane();
        $objectMap.put("factorCardinalityScrollPane", factorCardinalityScrollPane);
        factorCardinalityScrollPane.setName("factorCardinalityScrollPane");
        factorCardinalityScrollPane.setVisible(false);
    }

    protected void createFieldSensitivityCalculatorSelect() {
        fieldSensitivityCalculatorSelect = new jaxx.runtime.swing.JAXXComboBox();
        $objectMap.put("fieldSensitivityCalculatorSelect", fieldSensitivityCalculatorSelect);
        fieldSensitivityCalculatorSelect.setName("fieldSensitivityCalculatorSelect");
        fieldSensitivityCalculatorSelect.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $Table0, "doActionPerformed__on__fieldSensitivityCalculatorSelect"));
    }

    protected void createRemoveExportButton() {
        removeExportButton = new javax.swing.JButton();
        $objectMap.put("removeExportButton", removeExportButton);
        removeExportButton.setName("removeExportButton");
        removeExportButton.setEnabled(false);
        removeExportButton.setText(_("isisfish.common.remove"));
        removeExportButton.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $Table0, "doActionPerformed__on__removeExportButton"));
    }

    protected void createSelectedSensitivityExports() {
        selectedSensitivityExports = new jaxx.runtime.swing.JAXXList();
        $objectMap.put("selectedSensitivityExports", selectedSensitivityExports);
        selectedSensitivityExports.setName("selectedSensitivityExports");
        selectedSensitivityExports.addListSelectionListener((javax.swing.event.ListSelectionListener) jaxx.runtime.Util.getEventListener(javax.swing.event.ListSelectionListener.class, "valueChanged", $Table0, "doValueChanged__on__selectedSensitivityExports"));
    }

    protected void createSimulSensitivityCalculatorParam() {
        simulSensitivityCalculatorParam = new javax.swing.JTable();
        $objectMap.put("simulSensitivityCalculatorParam", simulSensitivityCalculatorParam);
        simulSensitivityCalculatorParam.setName("simulSensitivityCalculatorParam");
        simulSensitivityCalculatorParam.setRowHeight(24);
    }

}
