/* *##%
 * Copyright (C) 2009 Ifremer, Code Lutin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *##%*/

package fr.ifremer.isisfish.ui.sensitivity;

import static org.nuiton.i18n.I18n._;

import fr.ifremer.isisfish.simulator.sensitivity.domain.EquationContinuousDomain;
import fr.ifremer.isisfish.ui.simulator.SimulAction;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JOptionPane;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.topia.persistence.TopiaEntity;

/**
 * Action for sensitivity package.
 * 
 * @author letellier
 * @version $Revision: 2937 $
 *
 * Last update: $Date: 2010-01-22 16:39:11 +0100 (ven., 22 janv. 2010) $
 * by : $Author: chatellier $
 */
public class SensitivityAction {

    /** to use log facility, just put in your code: log.info(\"...\"); */
    private static Log log = LogFactory.getLog(SensitivityAction.class);

    public void saveContinue(JComponent cOrigine, String name,
            String comment, String path, ContinuousPanelContainerUI panel,
            SimulAction action, boolean exist) {
        DefaultContinuousPanelUI defaultPanel = null;
        if (panel instanceof MatrixContinuousPanelUI) {
            MatrixContinuousPanelUI matrixPanel = (MatrixContinuousPanelUI) panel;
            Double coef = Double.valueOf(matrixPanel.getCoef().getText()) / 100;
            MatrixND matrix = matrixPanel.getMatrix();
            String operateur = (String) matrixPanel.getOperator()
                    .getSelectedItem();
            action.addContinuousMatrixFactor(name, comment, path, coef, matrix,
                    operateur, cOrigine, exist);

        } else if (panel instanceof EquationContinuousPanelUI) {
            try {
                EquationContinuousPanelUI equationPanel = (EquationContinuousPanelUI) panel;

                TopiaEntity bean = equationPanel.getBean();
                //String methodSet = equationPanel.getMethodSet();
                String property = equationPanel.getBeanProperty();
                property = StringUtils.capitalize(property) + "Content";
                Method m = bean.getClass().getMethod("set" + property, String.class);
                m.invoke(bean, equationPanel.getEditor().getEditor().getText());

                // Save equation
                bean.update();
                bean.getTopiaContext().commitTransaction();

                List<EquationContinuousDomain> domains = equationPanel
                        .getDomains();
                for (EquationContinuousDomain domain : domains) {
                    if (domain.getReferenceValue() != null
                            && domain.getCoefficient() != null
                            && domain.getCoefficient() <= 100
                            && domain.getCoefficient() > 0
                            && domain.getOperator() != null
                            && domain.getVariableName() != null) {
                        action.addContinuousEquationFactor(name, comment, path,
                                domain, cOrigine, exist);
                    } else {
                        log.warn("domain: " + domain);
                        log.warn("domain invalid: "
                                + "domain.getReferenceValue() != null("
                                + (domain.getReferenceValue())
                                + ") domain.getCoefficient() != null("
                                + (domain.getCoefficient())
                                + ") domain.getCoefficient() <= 100 ("
                                + (domain.getCoefficient())
                                + ") domain.getCoefficient() > 0 ("
                                + (domain.getCoefficient())
                                + ") domain.getOperator() != null ("
                                + (domain.getOperator())
                                + ") domain.getVariableName() != null("
                                + (domain.getVariableName()) + ")");
                        JOptionPane.showMessageDialog(equationPanel,
                                _("isisfish.error.factor.invalid")
                                        + domain.getVariableName());
                    }
                }
            } catch (Exception ex) {
                if (log.isErrorEnabled()) {
                    log.error("Can't call method : ", ex);
                }
            }
        } else if (panel instanceof DefaultContinuousPanelUI) {
            defaultPanel = (DefaultContinuousPanelUI) panel;
            action.addContinuousFactor(name, comment, path,
                            getMin(defaultPanel), getMax(defaultPanel),
                            cOrigine, exist);
        }
    }

    protected Double getMin(DefaultContinuousPanelUI defaultPanel) {
        return Double.parseDouble(defaultPanel.getMin());
    }

    protected Double getMax(DefaultContinuousPanelUI defaultPanel) {
        return Double.parseDouble(defaultPanel.getMax());
    }

    public void saveDiscret(JComponent cOrigine, String name,
            String comment, String path, List<JComponent> components,
            SimulAction action, boolean exist) {
        List<Serializable> values = new ArrayList<Serializable>();
        for (JComponent c : components) {
            values.add((Serializable) EditorHelper.getValue(c));
        }
        action.addDiscreteFactor(name, comment, path, values, cOrigine, exist);
    }
}