package fr.ifremer.isisfish.ui.sensitivity;

import fr.ifremer.isisfish.ui.sensitivity.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.Table;
import static org.nuiton.i18n.I18n._;
import static jaxx.runtime.Util.createImageIcon;
import jaxx.runtime.SwingUtil;
import org.apache.commons.lang.StringUtils;
import org.nuiton.topia.persistence.TopiaEntity;
import fr.ifremer.isisfish.ui.simulator.SimulAction;
import fr.ifremer.isisfish.ui.input.InputSaveVerifier;
import fr.ifremer.isisfish.simulator.sensitivity.Factor;
import fr.ifremer.isisfish.simulator.sensitivity.Domain;
import fr.ifremer.isisfish.simulator.sensitivity.domain.ContinuousDomain;
import fr.ifremer.isisfish.simulator.sensitivity.domain.EquationContinuousDomain;
import fr.ifremer.isisfish.simulator.sensitivity.domain.DiscreteDomain;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FactorWizardUI extends javax.swing.JDialog implements jaxx.runtime.JAXXObject {
    public static final Log log = LogFactory.getLog(fr.ifremer.isisfish.ui.sensitivity.FactorWizardUI.class);
    private static java.lang.String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVWzY/bRBSfTTfJZpddSr+RiliWCCTUOmQp/WCrLe2WpRulpWqWtjRCYhzPZqeaeNyZcertAZC4ItQD4sAFuHPkjhBHTlz5HxDiP+DN2Inj1HUsnEMcv4+ff783z+/l579RWQr02kMcBJbwXUUHxGpdvX//I/sh6anrRPYE9RQXKPzMlVCpi5acsV0q9Hq3rdMbUXpjiw887hJ3InujjRalOmBE7hOiFDoeZvSkbHTG5o3A88UIbUwmDe3Hf/8pPXW+/KmEUOABq9MgYXVWVqxgvo1K1FHoCDxpiBsMu32gIajbB57L2rbFsJS38IA8Qp+jahtVPCwATKG1/FINhskPPIVq9dZ1ihnvv61Qc09YdE+QAYGrpHKPyn3Lp5YkrqSKDqk6sLZxD8Du0SdYOB/veJ5Bqih0uMfh0a5PbnMpqc2IQi9pxpZWYV3jnBHspoR3CIPzJI62r8T+JYmH5AMXA9C0a5kEVEJu/y5mPplyHq13jN4dFwhjRp8Q0VToVXMGPSgKZaDtmZDM/HXtOpkZ8s7skHOzQ96dHXJ+KqRa39UluqDQqUSbycdQH8v4dGRtnLBQb7WxTdhF6DJ9PEEUGlp10No4dnHPnLVuN4VOJKJ3SaC2KWFOMmN5dKp3sEO5ITWRZIzXfKW4m0w7FaVxX97GLmFbcIupS8Q0SeNN5lYdCh1OlL49m3SNtF7S929OMY3SbvkDmwhtfGtKfL0VUm3Ci3E0wSJNQlVhW7NT6GSyUNi2iaM9yfhaxK3ZTCG3Um/ByXPGdF5zfRoz9k1xgAYfmGlw/JnDuioI1mFXxtGVHnZ7YTUvJXEqMAH4kKR45vVbmWKPOmX3wIMCrKV0op7cYdk+FNz3oIGFLqp+KaW04lEbz8K5LioLH8wwK7rxVL4DpnAeR1YDYKw/fPX98Ltffn1vNHxfhmcsJ0ImdgUMQ09wD1qM6ke8GE5cX1HWuIm9jS6qSTOYzCI5NkGgE5mBBOCHI06nWTew3IfUcvWv334/8dmfh1BpGy0yjp1wYu6gmtoXoJIzJ/CuvG+YvPB4Ab4Pa05QdoYPONQIrVx2sMKrNnUdqN1mAGKPTYgdM/jj6dc3T3/zyoWR4LmQ0FRYLLr8AFWoy+DFMnsmWiGpe2XJk8R3eLwq0pbHnL4uetE06pjve2nKygPuYNNpDwJfX7qGrf71aX4QRZXeKkcuhxpWsYLVaPuKbP5/0HkF74b29tMx3siBsWTHjZ0BdSYH1IKc2IbPqdVsHG1mBZlUh9Rs8cJEPslAaORCeJQhZT0XwjCDQz6ErHLORoBykvivzHOInCtMJB/CtxkczhdGuFhYRT6ELA4buRC+KIyQpWKzMMJ2YYQbheuQDyHrLFqFVWiE/wDS9nZNDg4AAA==";
    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected java.util.Map<String,Object> $bindingSources = new HashMap<String,Object>();
    protected Map<String,Object> $objectMap = new HashMap<String,Object>();
    protected javax.swing.JButton cancel;
    protected javax.swing.JTextArea comment;
    protected java.lang.Boolean continuePossible;
    protected javax.swing.JRadioButton continueRadio;
    protected java.lang.Boolean continueSelected;
    protected javax.swing.JPanel continuousPanelContainer;
    protected final jaxx.runtime.JAXXContext delegateContext = new jaxx.runtime.DefaultJAXXContext(this);;
    protected javax.swing.JRadioButton discret;
    protected javax.swing.JTextField discretNumber;
    protected java.lang.Boolean existingValue;
    protected javax.swing.JTextField factorName;
    protected jaxx.runtime.swing.JAXXButtonGroup factorType;
    protected javax.swing.JButton remove;
    protected javax.swing.JButton save;
    protected java.lang.Boolean saveEnabled;
    protected javax.swing.JTabbedPane tabPane;
    private javax.swing.JButton $JButton10;
    private fr.ifremer.isisfish.ui.sensitivity.FactorWizardUI $JDialog0 = this;
    private javax.swing.JLabel $JLabel11;
    private javax.swing.JLabel $JLabel8;
    private javax.swing.JLabel $JLabel9;
    private javax.swing.JScrollPane $JScrollPane12;
    private jaxx.runtime.swing.Table $Table7;
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    java.util.Map $previousValues = new java.util.HashMap();
    private java.beans.PropertyChangeListener $DataSource16 = new jaxx.runtime.DataBindingListener($JDialog0, "continueRadio.visible");
    private java.beans.PropertyChangeListener $DataSource19 = new jaxx.runtime.DataBindingListener($JDialog0, "$JLabel9.enabled");
    private java.beans.PropertyChangeListener $DataSource20 = new jaxx.runtime.DataBindingListener($JDialog0, "discretNumber.enabled");
    private java.beans.PropertyChangeListener $DataSource21 = new jaxx.runtime.DataBindingListener($JDialog0, "$JButton10.enabled");
    private java.beans.PropertyChangeListener $DataSource22 = new jaxx.runtime.DataBindingListener($JDialog0, "tabPane.enabled");
    private java.beans.PropertyChangeListener $DataSource23 = new jaxx.runtime.DataBindingListener($JDialog0, "tabPane.visible");
    private java.beans.PropertyChangeListener $DataSource24 = new jaxx.runtime.DataBindingListener($JDialog0, "remove.visible");
    private java.beans.PropertyChangeListener $DataSource25 = new jaxx.runtime.DataBindingListener($JDialog0, "save.enabled");

    /* begin raw body code */
    protected JComponent cOrigine;
    protected TopiaEntity bean;
    protected java.util.List<JComponent> discretComponents;
    protected String path;
    protected ContinuousPanelContainerUI continuousPanel;
    protected Factor factor;
    
    
    public void initNew(JComponent c, TopiaEntity be, Boolean b) {
        this.bean = be;
        this.cOrigine = c;
    
        // path is topiaId#property
        // ex : fwn#fsd#0.3425345#name
        // for JAXX : cOrigine start with upper case
        // for commons beanutils : must be lower case
        String methodName = StringUtils.uncapitalize(EditorHelper.getMethod(cOrigine));
        this.path = bean.getTopiaId() + "#" + methodName;
    
        factorName.setText(bean.toString() + "." + methodName);
        setContinuePossible(b);
        boolean selected = EditorHelper.isContinue(cOrigine);
        setContinueSelected(selected);
        continueRadio.setSelected(selected);
        if (isContinuePossible()){
            if (EditorHelper.isRangeOfValue(cOrigine)) {
                jaxx.runtime.Util.assignment(continuousPanel = EditorHelper.getContinuousRangeOfValuePanel(cOrigine, bean), "continuousPanel", fr.ifremer.isisfish.ui.sensitivity.FactorWizardUI.this);
            }
            else {
                jaxx.runtime.Util.assignment(continuousPanel = EditorHelper.getContinuousPanel(cOrigine, bean), "continuousPanel", fr.ifremer.isisfish.ui.sensitivity.FactorWizardUI.this);
            }
            init();
        }
        if (!isContinueSelected() && EditorHelper.isRangeOfValue(cOrigine)) {
            int i = 0;
            for (String s : EditorHelper.getDiscretRangeOfValueValues(cOrigine, bean)) {
                JTextField text = new JTextField(s);
                discretComponents.add(text);
                tabPane.add(text, "Factor " + (i+1));
                i++;
            }
        }
        if (continuousPanel != null) {
            continuousPanel.setContinueSelected(selected);
        }
        setContinueSelected(EditorHelper.isContinue(cOrigine));
        setSaveEnabled(!factorName.getText().equals(""));
    }
    
    public void initExisting(JComponent cOrigine, Factor f) {
        setExistingValue(true);
        this.cOrigine = cOrigine;
        this.path = f.getPath();
        comment.setText(f.getComment());
        Domain domain = f.getDomain();
        this.factor = f;
    
        if (domain instanceof ContinuousDomain) {
            if (domain instanceof EquationContinuousDomain) {
                EquationContinuousDomain equationDomain = (EquationContinuousDomain)domain;
                String factorName2 = f.getName();
                String suffix = "." + equationDomain.getVariableName();
                if (factorName2.endsWith(suffix)) {
                    factorName2 = factorName2.substring(0, factorName2.length()-suffix.length());
                }
                factorName.setText(factorName2);
            }
            else {
                // for other ContinuousDomain name is the same
                factorName.setText(f.getName());
            }
            ContinuousDomain cDomain = (ContinuousDomain) domain;
    
            jaxx.runtime.Util.assignment(continuousPanel = EditorHelper.getContinuousPanelWithValue(cOrigine, cDomain, f), "continuousPanel", fr.ifremer.isisfish.ui.sensitivity.FactorWizardUI.this);
            init();
    
            continueRadio.setSelected(true);
            setContinueSelected(true);
            setContinuePossible(true);
        } else {
    
            // discret fator, name is the same
            factorName.setText(f.getName());
    
            DiscreteDomain dDomain = (DiscreteDomain)domain;
    
            int nb = dDomain.getValues().size();
            discretNumber.setText(nb + "");
    
            discretComponents.clear();
            tabPane.removeAll();
    
            SortedMap values = dDomain.getValues();
            int i = 0;
            Object cache = null;
            for (Object o : values.values()) {
                i++;
                cache = o;
                JComponent c = null;
                if (o != null) {
                    c = EditorHelper.getEditorWithValue(cOrigine, o);
                }
                else {
                    c = EditorHelper.getEditorWithValue(cOrigine);
                }
                discretComponents.add(c);
                JScrollPane js = new JScrollPane(c);
                tabPane.addTab("Factor " + i, js);
            }
            setContinuePossible(EditorHelper.canBeContinue(cOrigine, cache));
    
            this.pack();
        }
        setSaveEnabled(!factorName.getText().equals(""));
    }
    protected void init() {
        continuousPanelContainer.add(continuousPanel, BorderLayout.CENTER);
        this.pack();
    }
    protected JComponent getNewComponent() {
        return EditorHelper.getEditor(cOrigine, bean);
    }
    protected void addTabs(String sNbTab) {
        int nbTab = Integer.parseInt(sNbTab);
        discretComponents.clear();
        tabPane.removeAll();
        for (int i=0;i<nbTab;i++) {
            JComponent c = getNewComponent();
            discretComponents.add(c);
            JScrollPane js = new JScrollPane(c);
            tabPane.addTab("Factor " + (i+1), js);
        }
        this.pack();
    }
    protected SensitivityAction getSensitivityAction() {
        return getContextValue(SensitivityAction.class);
    }
    protected SimulAction getSimulAction() {
        return getContextValue(SimulAction.class);
    }
    protected void save() {
        if (continueRadio.isSelected()) {
            getSensitivityAction().saveContinue(cOrigine, factorName.getText(), comment.getText(), path, continuousPanel, getSimulAction(), isExistingValue());
        } else {
            getSensitivityAction().saveDiscret(cOrigine, factorName.getText(), comment.getText(), path, discretComponents, getSimulAction(), isExistingValue());
        }
        getContextValue(InputSaveVerifier.class).getSensPanel().setFactorModel();
        exit();
    }
    protected void remove() {
        getSimulAction().removeFactor(factor);
        getContextValue(InputSaveVerifier.class).getSensPanel().setFactorModel();
        exit();
    }
    protected void exit() {
        this.dispose();
    }
    /* end raw body code */
    /*---------------------------------------------------------------------------------*/
    /*-- Statics methods --------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public static jaxx.runtime.JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return jaxx.runtime.Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Constructors -----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public FactorWizardUI() {
        $initialize();
    }

    public FactorWizardUI(jaxx.runtime.JAXXContext parentContext) {
        if (parentContext instanceof jaxx.runtime.JAXXInitialContext) {
            ((jaxx.runtime.JAXXInitialContext)parentContext).to(this);
        } else {
            setContextValue(parentContext);
        }
        $initialize();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXObject implementation ----------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void applyDataBinding(String $binding) {
        if ("continueRadio.visible".equals($binding)) {
                addPropertyChangeListener("continuePossible", $DataSource16);
        
        } else if ("$JLabel9.enabled".equals($binding)) {
                addPropertyChangeListener("continueSelected", $DataSource19);
        
        } else if ("discretNumber.enabled".equals($binding)) {
                addPropertyChangeListener("continueSelected", $DataSource20);
        
        } else if ("$JButton10.enabled".equals($binding)) {
                addPropertyChangeListener("continueSelected", $DataSource21);
        
        } else if ("tabPane.enabled".equals($binding)) {
                addPropertyChangeListener("continueSelected", $DataSource22);
        
        } else if ("tabPane.visible".equals($binding)) {
                addPropertyChangeListener("continueSelected", $DataSource23);
        
        } else if ("remove.visible".equals($binding)) {
                addPropertyChangeListener("existingValue", $DataSource24);
        
        } else if ("save.enabled".equals($binding)) {
                addPropertyChangeListener("saveEnabled", $DataSource25);
        
        }
        processDataBinding($binding);
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    public Map<String,Object> get$objectMap() {
        return $objectMap;
    }

    public java.lang.Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    public void processDataBinding(String dest) {
        processDataBinding(dest, false);
    }

    public void processDataBinding(String $dest, boolean $force) {
        if (!$force && $activeBindings.contains($dest)) { 
            return;
        }
        $activeBindings.add($dest);
        try {
            if ("continueRadio.visible".equals($dest)) {
            continueRadio.setVisible((isContinuePossible()));
            } else if ("$JLabel9.enabled".equals($dest)) {
            $JLabel9.setEnabled((!isContinueSelected()));
            } else if ("discretNumber.enabled".equals($dest)) {
            discretNumber.setEnabled((!isContinueSelected()));
            } else if ("$JButton10.enabled".equals($dest)) {
            $JButton10.setEnabled((!isContinueSelected()));
            } else if ("tabPane.enabled".equals($dest)) {
            tabPane.setEnabled((!isContinueSelected()));
            } else if ("tabPane.visible".equals($dest)) {
            tabPane.setVisible((!isContinueSelected()));
            } else if ("remove.visible".equals($dest)) {
            remove.setVisible((isExistingValue()));
            } else if ("save.enabled".equals($dest)) {
            save.setEnabled((isSaveEnabled()));
            }} finally {
            $activeBindings.remove($dest);
        }
    }

    public void removeDataBinding(String $binding) {
        if ("continueRadio.visible".equals($binding)) {
                removePropertyChangeListener("continuePossible", $DataSource16);
        
        } else if ("$JLabel9.enabled".equals($binding)) {
                removePropertyChangeListener("continueSelected", $DataSource19);
        
        } else if ("discretNumber.enabled".equals($binding)) {
                removePropertyChangeListener("continueSelected", $DataSource20);
        
        } else if ("$JButton10.enabled".equals($binding)) {
                removePropertyChangeListener("continueSelected", $DataSource21);
        
        } else if ("tabPane.enabled".equals($binding)) {
                removePropertyChangeListener("continueSelected", $DataSource22);
        
        } else if ("tabPane.visible".equals($binding)) {
                removePropertyChangeListener("continueSelected", $DataSource23);
        
        } else if ("remove.visible".equals($binding)) {
                removePropertyChangeListener("existingValue", $DataSource24);
        
        } else if ("save.enabled".equals($binding)) {
                removePropertyChangeListener("saveEnabled", $DataSource25);
        
        }
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXContext implementation ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    public jaxx.runtime.JAXXContext getDelegateContext() {
        return delegateContext;
    }

    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return delegateContext.getParentContainer(clazz);
    }

    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return delegateContext.getParentContainer(source, clazz);
    }

    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Event methods ----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton10(java.awt.event.ActionEvent event) {
        addTabs(discretNumber.getText());
    }

    public void doActionPerformed__on__cancel(java.awt.event.ActionEvent event) {
        exit();
    }

    public void doActionPerformed__on__continueRadio(java.awt.event.ActionEvent event) {
        setContinueSelected(continueRadio.isSelected());
    }

    public void doActionPerformed__on__discret(java.awt.event.ActionEvent event) {
        setContinueSelected(continueRadio.isSelected());
    }

    public void doActionPerformed__on__remove(java.awt.event.ActionEvent event) {
        remove();
    }

    public void doActionPerformed__on__save(java.awt.event.ActionEvent event) {
        save();
    }

    public void doKeyReleased__on__factorName(java.awt.event.KeyEvent event) {
        setSaveEnabled(!factorName.getText().equals(""));
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public acessor methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public java.util.List<Object> get$activeBindings() {
        return $activeBindings;
    }

    public java.util.Map<String,Object> get$bindingSources() {
        return $bindingSources;
    }

    public javax.swing.JButton getCancel() {
        return cancel;
    }

    public javax.swing.JTextArea getComment() {
        return comment;
    }

    public java.lang.Boolean getContinuePossible() {
        return continuePossible;
    }

    public javax.swing.JRadioButton getContinueRadio() {
        return continueRadio;
    }

    public java.lang.Boolean getContinueSelected() {
        return continueSelected;
    }

    public javax.swing.JPanel getContinuousPanelContainer() {
        return continuousPanelContainer;
    }

    public javax.swing.JRadioButton getDiscret() {
        return discret;
    }

    public javax.swing.JTextField getDiscretNumber() {
        return discretNumber;
    }

    public java.lang.Boolean getExistingValue() {
        return existingValue;
    }

    public javax.swing.JTextField getFactorName() {
        return factorName;
    }

    public jaxx.runtime.swing.JAXXButtonGroup getFactorType() {
        return factorType;
    }

    public javax.swing.JButton getRemove() {
        return remove;
    }

    public javax.swing.JButton getSave() {
        return save;
    }

    public java.lang.Boolean getSaveEnabled() {
        return saveEnabled;
    }

    public javax.swing.JTabbedPane getTabPane() {
        return tabPane;
    }

    public java.lang.Boolean isContinuePossible() {
        return continuePossible !=null && continuePossible;
    }

    public java.lang.Boolean isContinueSelected() {
        return continueSelected !=null && continueSelected;
    }

    public java.lang.Boolean isExistingValue() {
        return existingValue !=null && existingValue;
    }

    public java.lang.Boolean isSaveEnabled() {
        return saveEnabled !=null && saveEnabled;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public mutator methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void setContinuePossible(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.continuePossible;
        this.continuePossible = newValue;
        firePropertyChange("continuePossible", oldValue, newValue);
    }

    public void setContinueSelected(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.continueSelected;
        this.continueSelected = newValue;
        firePropertyChange("continueSelected", oldValue, newValue);
    }

    public void setExistingValue(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.existingValue;
        this.existingValue = newValue;
        firePropertyChange("existingValue", oldValue, newValue);
    }

    public void setSaveEnabled(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.saveEnabled;
        this.saveEnabled = newValue;
        firePropertyChange("saveEnabled", oldValue, newValue);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- protected acessors methods ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    protected javax.swing.JButton get$JButton10() {
        return $JButton10;
    }

    protected fr.ifremer.isisfish.ui.sensitivity.FactorWizardUI get$JDialog0() {
        return $JDialog0;
    }

    protected javax.swing.JLabel get$JLabel11() {
        return $JLabel11;
    }

    protected javax.swing.JLabel get$JLabel8() {
        return $JLabel8;
    }

    protected javax.swing.JLabel get$JLabel9() {
        return $JLabel9;
    }

    protected javax.swing.JScrollPane get$JScrollPane12() {
        return $JScrollPane12;
    }

    protected jaxx.runtime.swing.Table get$Table7() {
        return $Table7;
    }

    protected java.lang.String get$jaxxObjectDescriptor() {
        return $jaxxObjectDescriptor;
    }

    protected java.util.Map get$previousValues() {
        return $previousValues;
    }

    protected boolean getAllComponentsCreated() {
        return allComponentsCreated;
    }

    protected boolean getContextInitialized() {
        return contextInitialized;
    }

    protected Log getLog() {
        return log;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- ui creation methods ----------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        $JDialog0.getContentPane().add($Table7, BorderLayout.CENTER);
        
        
        
        
        
        
        
        $Table7.add($JLabel8, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table7.add(factorName, new GridBagConstraints(1, 0, 3, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table7.add(continueRadio, new GridBagConstraints(0, 1, 4, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table7.add(continuousPanelContainer, new GridBagConstraints(0, 2, 4, 1, 1.0, 0.5, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table7.add(discret, new GridBagConstraints(0, 3, 4, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table7.add($JLabel9, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table7.add(discretNumber, new GridBagConstraints(1, 4, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table7.add($JButton10, new GridBagConstraints(2, 4, 2, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table7.add(tabPane, new GridBagConstraints(0, 5, 4, 1, 1.0, 0.3, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table7.add($JLabel11, new GridBagConstraints(0, 6, 4, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table7.add($JScrollPane12, new GridBagConstraints(0, 7, 4, 1, 1.0, 0.3, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table7.add(cancel, new GridBagConstraints(0, 8, 1, 1, 0.25, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table7.add(remove, new GridBagConstraints(1, 8, 1, 1, 0.25, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table7.add(save, new GridBagConstraints(2, 8, 2, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        
        addChildrenToContinueRadio();
        addChildrenToDiscret();
        
        
        
        $JScrollPane12.getViewport().add(comment);
        
        $JDialog0.setModal((true));
        continueRadio.setSelected((false));
        applyDataBinding("continueRadio.visible");
        discret.setSelected((true));
        applyDataBinding("$JLabel9.enabled");
        applyDataBinding("discretNumber.enabled");
        applyDataBinding("$JButton10.enabled");
        applyDataBinding("tabPane.enabled");
        applyDataBinding("tabPane.visible");
        applyDataBinding("remove.visible");
        applyDataBinding("save.enabled");
        $JDialog0.pack();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$JDialog0", this);
        createContinuePossible();
        createContinueSelected();
        createSaveEnabled();
        createExistingValue();
        
        cOrigine = null;
        
        bean = null;
        
        discretComponents = new ArrayList<JComponent>();
        
        path = null;
        
        continuousPanel = null;
        
        factor = null;
        
        $Table7 = new jaxx.runtime.swing.Table();
        $objectMap.put("$Table7", $Table7);
        $Table7.setName("$Table7");
        
        $JLabel8 = new javax.swing.JLabel();
        $objectMap.put("$JLabel8", $JLabel8);
        $JLabel8.setName("$JLabel8");
        $JLabel8.setText(_("isisfish.sensitivity.name"));
        
        createFactorName();
        createContinueRadio();
        createContinuousPanelContainer();
        createDiscret();
        
        $JLabel9 = new javax.swing.JLabel();
        $objectMap.put("$JLabel9", $JLabel9);
        $JLabel9.setName("$JLabel9");
        $JLabel9.setText(_("isisfish.sensitivity.selectDiscretNumber"));
        
        createDiscretNumber();
        create$JButton10();
        createTabPane();
        
        $JLabel11 = new javax.swing.JLabel();
        $objectMap.put("$JLabel11", $JLabel11);
        $JLabel11.setName("$JLabel11");
        $JLabel11.setText(_("isisfish.sensitivity.comment"));
        
        $JScrollPane12 = new javax.swing.JScrollPane();
        $objectMap.put("$JScrollPane12", $JScrollPane12);
        $JScrollPane12.setName("$JScrollPane12");
        
        createComment();
        createCancel();
        createRemove();
        createSave();
        createFactorType();
        $JDialog0.setName("$JDialog0");
        $JDialog0.getContentPane().setLayout((new BorderLayout()));
        $JDialog0.setTitle(_("isisfish.sensitivity.title"));
        
        
        addPropertyChangeListener("continuePossible", new PropertyChangeListener() {
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (continuousPanel != null) {
                    continuousPanel.setContinuePossible((Boolean)evt.getNewValue());
                }
            }
        });addPropertyChangeListener("continueSelected", new PropertyChangeListener() {
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (continuousPanel != null) {
                    continuousPanel.setContinueSelected((Boolean)evt.getNewValue());
                }
            }
        });
        $completeSetup();
    }

    protected void addChildrenToContinueRadio() {
        if (!allComponentsCreated) {
            return;
        }
        { javax.swing.ButtonGroup $buttonGroup = factorType; continueRadio.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(continueRadio); }
    }

    protected void addChildrenToDiscret() {
        if (!allComponentsCreated) {
            return;
        }
        { javax.swing.ButtonGroup $buttonGroup = factorType; discret.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(discret); }
    }

    protected void create$JButton10() {
        $JButton10 = new javax.swing.JButton();
        $objectMap.put("$JButton10", $JButton10);
        $JButton10.setName("$JButton10");
        $JButton10.setText(_("isisfish.sensitivity.validDiscretNumber"));
        $JButton10.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JDialog0, "doActionPerformed__on__$JButton10"));
    }

    protected void createCancel() {
        cancel = new javax.swing.JButton();
        $objectMap.put("cancel", cancel);
        cancel.setName("cancel");
        cancel.setText(_("isisfish.common.cancel"));
        cancel.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JDialog0, "doActionPerformed__on__cancel"));
    }

    protected void createComment() {
        comment = new javax.swing.JTextArea();
        $objectMap.put("comment", comment);
        comment.setName("comment");
        comment.setColumns(15);
        comment.setLineWrap(true);
        comment.setWrapStyleWord(true);
    }

    protected void createContinuePossible() {
        continuePossible = true;
        $objectMap.put("continuePossible", continuePossible);
    }

    protected void createContinueRadio() {
        continueRadio = new javax.swing.JRadioButton();
        $objectMap.put("continueRadio", continueRadio);
        continueRadio.setName("continueRadio");
        continueRadio.setText(_("isisfish.sensitivity.continue"));
        continueRadio.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JDialog0, "doActionPerformed__on__continueRadio"));
    }

    protected void createContinueSelected() {
        continueSelected = false;
        $objectMap.put("continueSelected", continueSelected);
    }

    protected void createContinuousPanelContainer() {
        continuousPanelContainer = new javax.swing.JPanel();
        $objectMap.put("continuousPanelContainer", continuousPanelContainer);
        continuousPanelContainer.setName("continuousPanelContainer");
        continuousPanelContainer.setLayout((new BorderLayout()));
    }

    protected void createDiscret() {
        discret = new javax.swing.JRadioButton();
        $objectMap.put("discret", discret);
        discret.setName("discret");
        discret.setText(_("isisfish.sensitivity.discret"));
        discret.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JDialog0, "doActionPerformed__on__discret"));
    }

    protected void createDiscretNumber() {
        discretNumber = new javax.swing.JTextField();
        $objectMap.put("discretNumber", discretNumber);
        discretNumber.setName("discretNumber");
        discretNumber.setColumns(15);
    }

    protected void createExistingValue() {
        existingValue = false;
        $objectMap.put("existingValue", existingValue);
    }

    protected void createFactorName() {
        factorName = new javax.swing.JTextField();
        $objectMap.put("factorName", factorName);
        factorName.setName("factorName");
        factorName.setColumns(15);
        factorName.addKeyListener((java.awt.event.KeyListener) jaxx.runtime.Util.getEventListener(java.awt.event.KeyListener.class, "keyReleased", $JDialog0, "doKeyReleased__on__factorName"));
    }

    protected void createFactorType() {
        factorType = new jaxx.runtime.swing.JAXXButtonGroup();
        $objectMap.put("factorType", factorType);
    }

    protected void createRemove() {
        remove = new javax.swing.JButton();
        $objectMap.put("remove", remove);
        remove.setName("remove");
        remove.setText(_("isisfish.common.remove"));
        remove.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JDialog0, "doActionPerformed__on__remove"));
    }

    protected void createSave() {
        save = new javax.swing.JButton();
        $objectMap.put("save", save);
        save.setName("save");
        save.setText(_("isisfish.common.save"));
        save.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JDialog0, "doActionPerformed__on__save"));
    }

    protected void createSaveEnabled() {
        saveEnabled = false;
        $objectMap.put("saveEnabled", saveEnabled);
    }

    protected void createTabPane() {
        tabPane = new javax.swing.JTabbedPane();
        $objectMap.put("tabPane", tabPane);
        tabPane.setName("tabPane");
    }

}
