/* *##%
 * Copyright (C) 2009 Ifremer, Code Lutin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *##%*/

package fr.ifremer.isisfish.ui.sensitivity;

import static org.nuiton.i18n.I18n._;

import java.awt.Component;
import java.util.List;

import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

import fr.ifremer.isisfish.simulator.sensitivity.Factor;

/**
 * Factor tree cell renderer.
 *
 * @author chatellier
 * @version $Revision: 2767 $
 * 
 * Last update : $Date: 2009-11-20 16:20:15 +0100 (ven., 20 nov. 2009) $
 * By : $Author: chatellier $
 */
public class FactorTreeCellRenderer extends DefaultTreeCellRenderer {

    /** serialVersionUID. */
    private static final long serialVersionUID = 1686424876690392268L;

    /*
     * @see javax.swing.tree.TreeCellRenderer#getTreeCellRendererComponent(javax.swing.JTree, java.lang.Object, boolean, boolean, boolean, int, boolean)
     */
    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value,
            boolean selected, boolean expanded, boolean leaf, int row,
            boolean hasFocus) {
        
        JLabel c = (JLabel)super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);

        if (value instanceof List<?>) {
            c.setText(_("isisfish.sensitivity.factors") + " : ");
        }
        else if (value instanceof Factor<?, ?>) {
            Factor<? ,?> factor = (Factor<?, ?>)value;
            c.setText(factor.getName());
        }

        return c;
    }
}
