package fr.ifremer.isisfish.ui.result;

import static org.nuiton.i18n.I18n._;

import com.bbn.openmap.gui.OMToolSet;
import com.bbn.openmap.gui.Tool;

import fr.ifremer.isisfish.entities.FisheryRegion;
import fr.ifremer.isisfish.map.ResultatLayer;

/**
* SimpleResultatMapBean.java
*
*
* Created: Fri Jun  7 13:02:18 2002
*
* @author <a href="mailto:seb.regnier@free.fr"></a>
* @version
*/

public class SimpleResultatMapBean extends SimpleResultatMapBeanUI {
    public SimpleResultatMapBean (){
        super();
        init();
        initBean();
    }

    protected void initBean(){
        // Create the directional and zoom control tool
        OMToolSet resultatMapOMTS = new OMToolSet();

        // Associate the tool with the map
        resultatMapOMTS.setupListeners(getIsisMapBean());

        // Add the tool to the map toolbar
        getIsisMapBeanToolBar().add((Tool)resultatMapOMTS);

        getInformationDelegator().setMap(getIsisMapBean());
        getInformationDelegator().setShowLights(false);
        getInformationDelegator().setLabel(_("isisfish.simpleResult.more.information"));
    }

    public void addResultatLayer(String id, ResultatLayer layer) {
        getIsisMapBean().addResultatLayer(id, layer);
        getLegendPanel().setModel(new LegendModel(0,Math.round(layer.getDataMapList().getMaxDataMapValue())));
        // poussin 20060822 FIXME: migration vers v3, je ne sais pas comment ca merchait avant, la methode n'existe pas :(
//        getInformationDelegator().addLayer(layer);
    }

    public void removeAllResultatLayer() {
        getIsisMapBean().removeAllResultatLayer();
    }

    public void setRegion(FisheryRegion region) {
        getIsisMapBean().setFisheryRegion(region);
    }

}// SimpleResultatMapBean
