/**
* ResultatEdit2.java
*
* Created: Wed Oct 23 2002
*
* @author  <poussin@codelutin.com>
* Copyright Code Lutin
* @version $Revision: 2833 $
*
* Mise a jour: $Date: 2009-12-14 19:24:08 +0100 (lun., 14 déc. 2009) $
* par : $Author: chatellier $
*/

package fr.ifremer.isisfish.ui.result;

import static org.nuiton.i18n.I18n._;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

import javax.swing.ButtonGroup;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.topia.TopiaContext;
import org.nuiton.util.FileUtil;
import org.nuiton.util.Resource;

import fr.ifremer.isisfish.datastore.ExportStorage;
import fr.ifremer.isisfish.datastore.ResultStorage;
import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.entities.FisheryRegion;
import fr.ifremer.isisfish.export.Export;
import fr.ifremer.isisfish.map.ResultatLayer;
import fr.ifremer.isisfish.simulator.SimulationParameter;
import fr.ifremer.isisfish.types.Date;

public class ResultEdit extends ResultEditUI { // ResultatEdit2

    /** to use log facility, just put in your code: log.info("..."); */
    static private Log log = LogFactory.getLog(ResultEdit.class);

    static final String ABONDANCE_STRING = _("isisfish.result.abundance");
    static final String CAPTUREPARMETIER_STRING = _("isisfish.result.capture.metier");
    static final String REJETPARMETIER_STRING = _("isisfish.result.reject.metier");
    static final String DEBARQUEMENTPARMETIER_STRING = _("isisfish.result.unload.metier");
    static final String EFFORTPARMETIER_STRING = _("isisfish.result.stress.metier");
    static final String CAPTURE_STRING = _("isisfish.result.capture");

    /** la simulation visualise */
    SimulationStorage simulation = null;
    /** le ResultatManager de la simulation */
    ResultStorage resultManager = null;

    // Les diffrentes vu des resultats
    DataResult dataBean;
    SimpleResultatMapBean mapBean;
    GraphBean graphBean;
    ResumePanel resumeBean;
    TopiaContext tx;
    
    /** les differents panel pour afficher les informations sur les
    * dimensions des matrices des resultats */
    InfoPanelable[] infoItemTab = null;

    public ResultEdit(SimulationStorage simulation) {
        setStatusOK(false);
        init();
        initObjet();
        setSimulation(simulation);
        setStatusOK(true);
    }

    @Override
    protected void finalize() throws Throwable {
        super.finalize();
        if (this.tx != null) {
            this.tx.closeContext();
        }
    }
    
    private void initObjet(){
        getResultat().setEditable(false);

        mapBean = new SimpleResultatMapBean();
        graphBean = new GraphBean();
        graphBean.setModel(new GraphBeanModel());
        dataBean = new DataResult();
        resumeBean = new ResumePanel();

        ButtonGroup group = new ButtonGroup();
        group.add(getMapRadioButton());
        group.add(getGraphRadioButton());
        group.add(getDonneeRadioButton());
        group.add(getResumeRadioButton());
        //	getResumeRadioButton().setSelected(true);

        getAjoutRendu().setText(null);
        getAjoutRendu().setIcon(Resource.getIcon("images/Right.gif"));
        getAjoutRendu().setMargin(new Insets(0,0,0,0));
        getStatusImage().setMargin(new Insets(0,0,0,0));

        getViewPanel().setLayout(new GridBagLayout());
    }

    void setStatusOK(boolean state) {
        if (state){
            getStatusImage().setIcon(Resource.getIcon("images/BulbG.gif"));
        }else{
            getStatusImage().setIcon(Resource.getIcon("images/BulbR.gif"));
        }
        getStatusImage().paintImmediately(0,0,25,25);
    }

    /**
    * Method updateInfoPanel permet de mettre a jour le
    * infoItemTab. Le 0 contient les dates.
    *
    * @param group le group utilise pour mettre a jour le infoItemTab
     * @return todo
    */
    protected InfoPanelable [] createInfoPanel(MatrixND group) {
        if (group == null){
            return new InfoPanelable[0];
        }

        InfoPanelable [] result = new InfoPanelable[group.getNbDim()];

        // les dates sont toujours dans la dimension 0
        InfoItemDate infoItemDate = new InfoItemDate();
        infoItemDate.getList().setListData(group.getSemantics(0).toArray());
        result[0] = infoItemDate;

        for (int i=1; i < group.getNbDim(); i++) {
            InfoItem item = new InfoItem();

            // on affecte le nom
            if (group.getDimensionName(i).equals("")){
                item.getLabel().setText(_("isisfish.result.dimension") + " " + i);
            }else{
                item.getLabel().setText(_(group.getDimensionName(i)));
            }

            List elems = group.getSemantics(i);
            item.getList().setListData(elems.toArray());
            //?? 	    item.setPosition(i);
            result[i] = item;
        }

        return result;
    }

    void redrawInfoPanel(InfoPanelable[] infoItems){
        // Affichage dans le panel
        getInfoPanel().removeAll();
        getInfoPanel().setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1;
        c.weighty = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.fill = GridBagConstraints.BOTH;
        for(int i=0; i<infoItems.length; i++){
            c.gridy = i;
            getInfoPanel().add((Component)infoItems[i], c);
        }


        getScroll().invalidate();
        getScroll().validate();
        repaint();
    }

    /**
    * Get the value of simulation.
    * @return value of simulation.
    */
    public SimulationStorage getSimulation() {
        return simulation;
    }

    /**
    * Set the value of simulation.
    * @param simulation  Value to assign to simulation.
    */
    public void setSimulation(SimulationStorage  simulation) {
        try {
            this.simulation = simulation;
            if (this.tx != null) {
                this.tx.closeContext();
            }
            this.tx = simulation.getStorage().beginTransaction();
            FisheryRegion region = SimulationStorage.getFisheryRegion(this.tx);
            //FisheryRegion region = simulation.getFisheryRegion();

            mapBean.setRegion(region);
            
            resultManager = simulation.getResultStorage();
            getResultat().removeAllItems();
            for(String item : resultManager.getResultName()){
                getResultat().addItem(item);
            }
            loadResume(simulation, resultManager);
        } catch (Exception eee) {
            log.warn("Can't change simulation storage", eee);
        }
    }

//    protected MatriceND reduire2D(MatriceND matrice){
//        int aGarder = 2;
//        for (int j=0; j<matrice.getNbDim(); j++){
//            if (matrice.getDim(j) > 1 )
//                aGarder--;
//        }
//
//        int [] dimValid = new int[matrice.getNbDim()];
//        for (int j=0; j<matrice.getNbDim(); j++){
//            if (matrice.getDim(j) > 1 || aGarder > 0){
//                dimValid[j] = -1;
//                if (matrice.getDim(j) <= 1)
//                    aGarder --;
//            }
//            else
//                dimValid[j] = 0;
//        }
//
////         reduction de la matrice
//        return matrice.get(dimValid);
//    }

    public void loadResume(SimulationStorage simulation, ResultStorage resultManager){
        SimulationParameter sp = simulation.getParameter();
        StringBuffer resume = new StringBuffer(sp.toString());
        resume.append("\n");

        // TODO EC20090717 ca marche plus ca
        // les results name ne commence plus par ABONDANCE_STRING...
        for(Iterator i=resultManager.getResultName().iterator(); i.hasNext();){
            String name = (String)i.next();
            try {

                if (name.startsWith(ABONDANCE_STRING)){
                    MatrixND mat1 = resultManager.getMatrix(new Date(0), name, tx);
                    mat1 = mat1.sumOverDim(0);
                    mat1 = mat1.sumOverDim(1);
                    mat1 = mat1.reduce();
                    resume.append(_("isisfish.result.begin.simulation")).append(mat1.getName()).append(": ").append(mat1.getValue(0)).append("\n");

                    mat1 = resultManager.getMatrix(resultManager.getLastDate(), name, tx);
                    mat1 = mat1.sumOverDim(0);
                    mat1 = mat1.sumOverDim(1);
                    mat1 = mat1.reduce();
                    resume.append(_("isisfish.result.end.simulation")).append(mat1.getName()).append(": ").append(mat1.getValue(0)).append("\n");
                }
                else if(name.startsWith(REJETPARMETIER_STRING)){
                    MatrixND mat1 = resultManager.getMatrix(name, tx);
                    mat1 = mat1.sumOverDim(0);
                    mat1 = mat1.sumOverDim(1);
                    mat1 = mat1.sumOverDim(2);
                    mat1 = mat1.sumOverDim(3);

                    mat1 = mat1.reduce();
                    resume.append(_("isisfish.common.sum")).append(mat1.getName()).append(": ").append(mat1.getValue(0)).append("\n");
                }
                else if (!name.startsWith(CAPTUREPARMETIER_STRING) && name.startsWith(CAPTURE_STRING)){
                    MatrixND mat1 = resultManager.getMatrix(name, tx);
                    mat1 = mat1.sumOverDim(0);
                    mat1 = mat1.sumOverDim(1);
                    mat1 = mat1.sumOverDim(2);

                    mat1 = mat1.reduce();
                    resume.append(_("isisfish.common.sum")).append(mat1.getName()).append(": ").append(mat1.getValue(0)).append("\n");
                }
            } catch (Exception eee) {
                resume.append(_("isisfish.error.no.matrix", name));
            }
        }
        
        resume.append("\n\n");
        resume.append(simulation.getInformation().toString());

        resumeBean.setResume(resume.toString());
        getResumeRadioButton().setSelected(true);
    }

//    /**
//    * Method groupResult permet de grouper les resultats par nom.
//    *
//    * @param simulation la simulation dont il faut grouper les resultats
//    * @return une hash de ResultatGroup
//    */
//    HashMap groupResult(Simulation simulation){
//        HashMap result = new HashMap();
//
//        LinkedList resultats = Resultat.xmlToVector(simulation.getResultat());
//        for (Iterator it = resultats.iterator(); it.hasNext();) {
//            Resultat resultat = (Resultat)it.next();
//            String name = resultat.getName();
//
////             stockage des resultats par type
//            ResultatGroup group = (ResultatGroup)result.get(name);
//            if (group == null) {
////                group = new ResultatGroup(dbSimulation);
//                group = new ResultatGroup(dbManager);
//                result.put(name, group);
//            }
//            group.add(resultat);
//        }
//
//        return result;
//    }

    /**
    * Method reduction permet de reduire la matrice en fonction des
    * selections de l'utilisateur dans l'interface.
    *
    * @param matrix todo
     *
     * @param infoItems todo
     * @return todo
     */
    protected MatrixND createAndReduce(MatrixND matrix, InfoPanelable [] infoItems){

        // Reduit la matrice en fonction des choix de l utilisateur
        // dans les autres InfoItem recuperation des autres elements
        // selectionnees.
        for (int i = 0; i < infoItems.length; i++) {
            InfoPanelable item = infoItems[i];
            JList list = item.getList();
            int [] indList = list.getSelectedIndices();

            if (indList.length == 0){
                // si rien n'est selectionné on selection tout
                list.setSelectionInterval(0,
                list.getModel().getSize()-1);
                indList = list.getSelectedIndices();
            }

            log.debug("matrice avant submatrice de la dim "+i+" :"+matrix);

            if (0 < indList.length && indList.length < matrix.getDim(i)){
                matrix = matrix.getSubMatrix(i, indList);
            }

            log.debug("matrice apres submatrice de la dim "+i+" :"+matrix);

            if (item.getSumStep() != 1) {
                // on somme
                matrix = matrix.sumOverDim(i, item.getSumStep());
                if(matrix.getDim(i) == 1){
                    // c une somme global sur tous les elements
                    matrix.setDimensionName(i, _("isisfish.common.sum"));
                }else{
                    // c une somme partielle
                    String name = matrix.getDimensionName(i)+" "+
                    _("isisfish.common.sum");

                    //si c une somme pour les annees, on change l'intitule
                    if (item instanceof InfoItemDate){
                        name = _("isisfish.common.year");
                    }

                    matrix.setDimensionName(i, name);
                }

                // #1905 : modifie les semantiques de type Date pour que lorsque
                // c'est par exemple une somme par année
                // les semantique se nomment
                // janvier 0, janvier 1...
                // plutot que
                // janvier 0, fevrier 0...
                Object sem = matrix.getSemantics(i);
                if (sem instanceof List) {
                    List<Object> semList = (List<Object>)sem;
                    List<Object> newList = new ArrayList<Object>();
                    for (int index = 0 ; index < semList.size(); ++index) {
                        Object semObject = semList.get(index);
                        if (semObject instanceof Date) {
                            Date semDate = (Date)semObject;
                            Date newDate = new Date(semDate.getDate() * item.getSumStep());
                            newList.add(newDate);
                        }
                        else {
                            newList.add(semObject);
                        }
                    }
                    matrix.setSemantics(i, newList);
                }
                // end semantics modification
            }
            log.debug("matrice apres sum de la dim "+i+" :"+matrix);
        }

        log.debug("Matrice avant le reduce: " + matrix);

        // arrive ici on a une matrice qui a des tailles de dimension 1
        // et un tableau des legende pour chaque dimension

        // il faut que la matrice est 2 dimensions
        // reduction de la matrice
        MatrixND result = matrix.reduce(2);

        return result;
    }

    public void addRendu(MatrixND matrix, InfoPanelable [] infoItems){
        setStatusOK(false);

        log.debug("La matrice avant réduction est: " + matrix);

        // recuperation de la matriceInfo
        MatrixND matInfo = createAndReduce(matrix, infoItems);

        log.debug("La matrice après réduction est: " + matInfo);

        if (matInfo.getNbDim() > 2) {
            // matrice superieur a 2 dimensions non geree!!
            JOptionPane.showMessageDialog(null, _("isisfish.error.matrix.more.2d"), _("isisfish.common.alert"), JOptionPane.ERROR_MESSAGE);
            return;
        }

        // ajout a la carte
        // On ajoute a la carte que si on le peut
        if (matInfo.getNbDim() == 2){
            try{
                ResultatLayer layer = new ResultatLayer();
                layer.setMatriceInfo(matInfo);
                mapBean.removeAllResultatLayer();
                mapBean.addResultatLayer(matInfo.getName(), layer);
            }catch(Exception eee){
                log.warn("Erreur lors de l'ajout du résultat à la carte. ", eee);
                JOptionPane.showMessageDialog(null, _("isisfish.error.add.card"), _("isisfish.common.alert"), JOptionPane.ERROR_MESSAGE);
            }
        }

        // ajout au graph
        try{
            graphBean.getModel().setMatrix(matInfo);
        }catch(Exception eee){
            log.warn("Erreur lors de l'ajout du résultat au graph.", eee);
            JOptionPane.showMessageDialog(null, _("isisfish.error.add.result.graph"), _("isisfish.common.alert"), JOptionPane.ERROR_MESSAGE);
        }

        // ajout au data
        try{
            dataBean.setMatrix(matInfo);
        }catch(Exception eee){
            log.warn("Erreur lors de l'ajout du résultat au data.", eee);
            JOptionPane.showMessageDialog(null, _("isisfish.error.add.result.data"), _("isisfish.common.alert"), JOptionPane.ERROR_MESSAGE);
        }

        setStatusOK(true);
    }

    public void on_ajoutRendu_clicked(){
        String resultName = (String)getResultat().getSelectedItem();
        if (resultName != null) {
            // si on etait sur le resume on se met automatiquement sur le graph
            if (getViewPanel().getComponentCount() == 1 &&
                getViewPanel().getComponent(0) == resumeBean){
                    graphBean.getGraphSplitPane().setDividerLocation(1.0);
                    getGraphRadioButton().setSelected(true);
                }
                // on ajoute de rendu
                addRendu(resultManager.getMatrix(resultName, tx), infoItemTab);
        }
    }

    public void on_resultat_selection_notify_event(ItemEvent e){
        if(e.getStateChange() == ItemEvent.SELECTED){
            String resultName = (String)e.getItem();
            MatrixND matrix = resultManager.getMatrix(resultName, tx);
            infoItemTab = createInfoPanel(matrix);
            redrawInfoPanel(infoItemTab);
        }
    }

    public void on_graphRadioButton_toggled(ChangeEvent e){
        if (getGraphRadioButton().isSelected()){
            graphBean.getGraphSplitPane().setDividerLocation(1.0);
            setViewBean(graphBean);
        }
    }

    public void on_mapRadioButton_toggled(ChangeEvent e){
        if (getMapRadioButton().isSelected())
            setViewBean(mapBean);
    }

    public void on_donneeRadioButton_toggled(ChangeEvent e){
        if (getDonneeRadioButton().isSelected())
            setViewBean(dataBean);
    }

    public void on_resumeRadioButton_toggled(ChangeEvent e){
        if (getResumeRadioButton().isSelected())
            setViewBean(resumeBean);
    }

    /**
    * Method setViewBean modifie le bean visible.
    *
    * @param bean le bean qui doit devenir visible
    */
    public void setViewBean(JPanel bean){
        setStatusOK(false);

        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1;
        c.weighty = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.fill = GridBagConstraints.BOTH;

        getViewPanel().removeAll();
        getViewPanel().add(bean,c);
        getViewPanel().invalidate();
        getViewPanel().validate();
        getViewPanel().repaint();
        graphBean.getGraphSplitPane().setDividerLocation(1.0);
        setStatusOK(true);
    }

    //////////////////////////////////////////////////////////////////////
    ///                Menu Export                                     ///
    //////////////////////////////////////////////////////////////////////


    /**
    * Surcharge de la method getMenuExport_menuChilds pour ajouter
    * les methods que l'on trouve dans les scripts de l'objet Export.
    */
    public Vector getMenuExport_menuChilds(){
        Vector<JMenuItem> result = new Vector<JMenuItem>();
        for (String name : ExportStorage.getExportNames()) {
            JMenuItem item = getExportMenu(name);
            result.add(item);
        }
        return result;
    }

    /**
    * Retourne l'item de menu qui permet l'appelle de la method du code
    * ECMAScript d'export.
     * @param methodName todo
     * @return todo
     */
    protected JMenuItem getExportMenu(String methodName){
        JMenuItem result = new JMenuItem(_(methodName));
        result.addActionListener(new ExportActionListener(methodName));
        return result;
    }


    protected class ExportActionListener implements ActionListener{
        private String name;
        public ExportActionListener(String name){
            this.name = name;
        }
        public void actionPerformed(ActionEvent e){
            try{
                File file = FileUtil.getFile(".+.txt", _("isisfish.result.export.file"));
                if(file != null){
                    Writer out = new BufferedWriter(new FileWriter(file));
                    ExportStorage storage = ExportStorage.getExport(name);
                    Export export = storage.getNewExportInstance();
                    export.export(simulation, out);
                    out.close();
                }                
            }catch(Exception eee){
                log.warn("Erreur lors de l'export ", eee);
            }
        }
    }

} // ResultatEdit2
