package fr.ifremer.isisfish.ui.result;

import org.nuiton.math.matrix.MatrixND;
import org.nuiton.math.matrix.MatrixException;
import fr.ifremer.isisfish.types.Date;
import javax.swing.table.AbstractTableModel;

/**
 * MatrixInfoTableModel.
 *
 * Created: Fri May 31 18:31:20 2002
 *
 * @author <a href="mailto:seb.regnier@free.fr"></a>
 * @version $Revision: 2658 $
 */
public class MatrixInfoTableModel extends AbstractTableModel {

    /** serialVersionUID */
    private static final long serialVersionUID = 2632133167225155487L;
    
    protected MatrixND matrix;

    public MatrixInfoTableModel (MatrixND mat){
        if (mat.getNbDim() > 2){
            throw new MatrixException("matrice with more than 2 dimension not supported.");
        }
        this.matrix = mat;
    }

    /**
    * @return Le nombre de lignes de la table.
    */
    public int getRowCount() {
        if (matrix == null || matrix.getNbDim() < 1){
            return 0;
        }else{
            return matrix.getDim(0);
        }
    }

    /**
    * @return Le nombre de colonnes de la table.
    */
    public int getColumnCount() {
        if (matrix == null || matrix.getNbDim() < 1){
            return 0;
        }else{
            return matrix.getDim(1) + 1;
        }
    }

    /**
    * @param row La ligne
    * @param column La colonnes
    * @return L'Object correspondant dans la matrice.
    */
    public Object getValueAt(int row, int column) {
        if (column == 0){
            Object obj = matrix.getSemantics(0).get(row);
            if (obj instanceof Date){
                return ((Date)obj).getMonth().toString()+" "+((Date)obj).getYear();
            }else{
                return obj.toString();
            }
        }
        else {
            if (matrix.getNbDim() == 1){
                return ""+matrix.getValue(column-1);
            }else{ // mat.getNbDim() == 2
                return ""+matrix.getValue(row, column-1);
            }
        }
    }

//    /**
//    * @param obj L'objet a inserer dans la matrice.
//    * @param row La ligne
//    * @param column La colonnes
//    */
//    public void setValueAt(Object obj, int row, int column) {
//    }
//
//    /**
//    * Le modele est rendu editable.
//    */
//    public boolean isCellEditable(int row, int column) {
//        return false;
//    }

    public String getColumnName(int column){
        if (column == 0){
            return matrix.getDimensionName(0)+"\\"+matrix.getDimensionName(1);
        }
        else{
            return ""+matrix.getSemantics(1).get(column-1);
        }
    }

}// MatrixInfoTableModel
