
/**
* InfoItemDate.java
*
*
* Created: Thu Jul 06 14:06:32 2000
*
* @author PERNEL Xavier
* @version $Revision: 2658 $
*
* Mise a jour: $Date: 2009-10-13 17:00:50 +0200 (mar., 13 oct. 2009) $
* par : $Author: chatellier $
*/

package fr.ifremer.isisfish.ui.result;

import static org.nuiton.i18n.I18n._;

import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.ListSelectionModel;

import org.nuiton.util.Resource;

public class InfoItemDate extends InfoItemDateUI implements InfoPanelable {

    protected  int position;

    public InfoItemDate() {
        super();
        init();

        getLabel().setText(_("isisfish.common.date"));
        ImageIcon sigmabarre = Resource.getIcon("images/sigma-barre.gif");
        ImageIcon sigma = Resource.getIcon("images/sigma.gif");
        getSumButton().setSelectedIcon(sigma);
        getSumButton().setIcon(sigmabarre);
        getSumButton().setBorder(BorderFactory.createEtchedBorder());
        getSumButton().setBorderPainted(true);
        getSumButton().setToolTipText(_("isisfish.infoItem.sum"));

        ImageIcon sigmaAnBarre = Resource.getIcon("images/sigma_an-barre.gif");
        ImageIcon sigmaAn = Resource.getIcon("images/sigma_an.gif");
        getSumAnButton().setSelectedIcon(sigmaAn);
        getSumAnButton().setIcon(sigmaAnBarre);
        getSumAnButton().setBorder(BorderFactory.createEtchedBorder());
        getSumAnButton().setBorderPainted(true);
        getSumAnButton().setToolTipText(_("isisfish.infoItem.sum.year"));

        getList().setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
        getList().setCellRenderer(new InfoItemDateListRenderer());
    }

    /**
    * Get the value of position.
    * @return value of position.
    */
    public int getPosition() {
        return position;
    }

    /**
    * Set the value of position.
    * @param v  Value to assign to position.
    */
    public void setPosition(int  v) {
        this.position = v;
    }

    /**
    * Method getSumStep indique le pas d'increment pour la somme sur
    * la dimension.
    *
    * @return -1 indique de faire la somme sur tous les elmements. 1
    * indique de faire la somme 1 a 1 (donc de ne pas faire de
    * somme), 2 indiques de faire la somme 2 a 2, ...
    */
    public int getSumStep(){
        if (getSumButton().isSelected()){
            return -1;
        }else if (getSumAnButton().isSelected()){
            return 12;
        }else{
            return 1;
        }
    }
} // InfoItemDate
