
/**
* InfoItem.java
*
*
* Created: Thu Jul 06 13:54:59 2000
*
* @author PERNEL Xavier
* @version $Revision: 2658 $
*
* Mise a jour: $Date: 2009-10-13 17:00:50 +0200 (mar., 13 oct. 2009) $
* par : $Author: chatellier $
*/

package fr.ifremer.isisfish.ui.result;

import static org.nuiton.i18n.I18n._;

import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.ListSelectionModel;

import org.nuiton.util.Resource;

public class InfoItem extends InfoItemUI implements InfoPanelable {

    protected  int position;

    public InfoItem() {
        super();
        init();

        ImageIcon sigmabarre = Resource.getIcon("images/sigma-barre.gif");
        ImageIcon sigma = Resource.getIcon("images/sigma.gif");
        getSumButton().setSelectedIcon(sigma);
        getSumButton().setIcon(sigmabarre);
        getSumButton().setBorder(BorderFactory.createEtchedBorder());
        getSumButton().setBorderPainted(true);
        getSumButton().setToolTipText(_("isisfish.infoItem.sum"));

        getList().setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
    }

    /**
    * Get the value of position.
    * @return value of position.
    */
    public int getPosition() {
        return position;
    }

    /**
    * Set the value of position.
    * @param v  Value to assign to position.
    */
    public void setPosition(int  v) {
        this.position = v;
    }

    /**
    * Method getSumStep indique le pas d'increment pour la somme sur
    * la dimension.
    *
    * @return -1 indique de faire la somme sur tous les elmements. 1
    * indique de faire la somme 1 a 1 (donc de ne pas faire de
    * somme), 2 indiques de faire la somme 2 a 2, ...
    */
    public int getSumStep(){
        if (getSumButton().isSelected()){
            return -1;
        }else{
            return 1;
        }
    }
} // InfoItem
