package fr.ifremer.isisfish.ui.result;

import static org.nuiton.i18n.I18n._;

import java.awt.Component;

import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;

import org.jfree.chart.renderer.category.AreaRenderer;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.BarRenderer3D;
import org.jfree.chart.renderer.category.IntervalBarRenderer;
import org.jfree.chart.renderer.category.LayeredBarRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.renderer.category.LineRenderer3D;
import org.jfree.chart.renderer.category.MinMaxCategoryRenderer;
import org.jfree.chart.renderer.category.StackedAreaRenderer;
import org.jfree.chart.renderer.category.StackedBarRenderer;

/**
 * GraphComboRenderer.
 *
 * Created: Thu Sep 12 19:55:10 2002
 *
 * @author <a href="mailto:seb.regnier@free.fr"></a>
 * @version $Revision: 2787 $
 */
public class GraphComboRenderer extends DefaultListCellRenderer {

    /** serialVersionUID */
    private static final long serialVersionUID = 5439698068065934760L;

    public GraphComboRenderer() {
        super();
    }

    public Component getListCellRendererComponent(JList liste, Object o,
            int attributeIndex, boolean isSelected, boolean hasFocus) {
        super.getListCellRendererComponent(liste, o, attributeIndex,
                isSelected, hasFocus);
        if (o instanceof StackedBarRenderer) {
            setText(_("isisfish.graphCombo.render.bar.stacked"));
        } else if (o instanceof BarRenderer3D) {
            setText(_("isisfish.graphCombo.render.bar.3d"));
        } else if (o instanceof BarRenderer) {
            setText(_("isisfish.graphCombo.render.bar"));
        } else if (o instanceof StackedAreaRenderer) {
            setText(_("isisfish.graphCombo.render.surface.stacked"));
        } else if (o instanceof AreaRenderer) {
            setText(_("isisfish.graphCombo.render.surface"));
        } else if (o instanceof LineRenderer3D) {
            setText(_("isisfish.graphCombo.render.line.3d"));
        } else if (o instanceof LineAndShapeRenderer) {
            setText(_("isisfish.graphCombo.render.line"));
        } else if (o instanceof MinMaxCategoryRenderer) {
            setText(_("isisfish.graphCombo.render.min.max"));
        } else {
            setText((o == null) ? "" : o.toString());
        }
        return this;
    }
}// GraphComboRenderer
