/**
 * GraphBean
 *
 * Generated: Thu Jul 27 22:04:40 CEST 2006
 * By GGen Copyright Code Lutin
 * http://www.codelutin.com
 *
 */

package fr.ifremer.isisfish.ui.result;

import static org.nuiton.i18n.I18n._;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Vector;

import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JViewport;

public abstract class GraphBeanUI extends JPanel implements GraphBeanUICallback{

    protected void init(){
        GraphBeanUI result = this;
        this.setLayout(new BorderLayout());
        Vector childs = getGraphBeanChilds();
        if(childs.size() >= 1)
            result.add((Component)childs.get(0),
                    BorderLayout.CENTER);

        result.setBounds(0,0,0,0);
    }

    public void center(){
        // Center the screen
        Toolkit tk = this.getToolkit();
        Dimension d = this.getSize();
        int x = (tk.getScreenSize().width - d.width) / 2;
        int y = (tk.getScreenSize().height - d.height) / 2;
        this.setLocation(x, y);
    }

    protected HashMap<String,ButtonGroup> hashGroup = null;

    protected void group(AbstractButton b, String groupName){
        if(hashGroup == null)
            hashGroup = new HashMap<String,ButtonGroup>();
        ButtonGroup bg = hashGroup.get(groupName);
        if(bg == null){
            bg = new ButtonGroup();
            hashGroup.put(groupName, bg);
        }
        bg.add(b);
    }

    public Vector getGraphBeanChilds(){
        Vector<Object> result = new Vector<Object>();
        result.add(getGraphSplitPane());
        return result;
    }

    private JSplitPane __graphSplitPane__ = null;
    public JSplitPane getGraphSplitPane(){
        if(__graphSplitPane__ == null){
            Vector childs = getGraphSplitPaneChilds();
            Component child1 = null;
            Component child2 = null;
            if(childs.size() >= 1)
                child1 = (Component)childs.get(0);
            if(childs.size() >= 2)
                child2 = (Component)childs.get(1);

            JSplitPane result = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT,
                    child1, child2);
            result.setOneTouchExpandable(true);
            result.setDividerSize(10);

            __graphSplitPane__ = result;
        }
        return __graphSplitPane__;
    }

    public Vector getGraphSplitPaneChilds(){
        Vector<Object> result = new Vector<Object>();
        result.add(getTable3());
        result.add(getTable1());
        return result;
    }

    private JPanel __table3__ = null;
    public JPanel getTable3(){
        if(__table3__ == null){
            Vector childs = getTable3Childs();
            GridBagConstraints [] cs = new GridBagConstraints[childs.size()];
            GridBagConstraints c;

            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.weightx = 0;
            c.weighty = 0;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.fill = GridBagConstraints.NONE;
            cs[0] = c;

            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 1;
            c.weightx = 1;
            c.weighty = 3;
            c.gridwidth = 2;
            c.gridheight = 1;
            c.fill = GridBagConstraints.BOTH;
            cs[1] = c;

            c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = 0;
            c.weightx = 1;
            c.weighty = 0;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.fill = GridBagConstraints.HORIZONTAL;
            cs[2] = c;

            JPanel result = new JPanel(new GridBagLayout());
            for(int i=0; i<childs.size(); i++)
                result.add((Component)childs.get(i), cs[i]);

            __table3__ = result;
        }
        return __table3__;
    }

    public Vector getTable3Childs(){
        Vector<Object> result = new Vector<Object>();
        result.add(getLabel1());
        result.add(getScrolledwindow1());
        result.add(getGraphRendererCombo());
        return result;
    }

    private JLabel __label1__ = null;
    public JLabel getLabel1(){
        if(__label1__ == null){
            JLabel result = new JLabel(_("isisfish.graphBean.graph.render"));

            __label1__ = result;
        }
        return __label1__;
    }

    private JScrollPane __scrolledwindow1__ = null;
    public JScrollPane getScrolledwindow1(){
        if(__scrolledwindow1__ == null){
            Vector childs = getScrolledwindow1Childs();
            Component child = null;
            if(childs.size() >= 1)
                child = (Component)childs.get(0);

            JScrollPane result;
            if(child instanceof JViewport){
                result = new JScrollPane();
                result.setViewport((JViewport)child);
            }
            else
                result = new JScrollPane(child);

            __scrolledwindow1__ = result;
        }
        return __scrolledwindow1__;
    }

    public Vector getScrolledwindow1Childs(){
        Vector<Object> result = new Vector<Object>();
        result.add(getViewport1());
        return result;
    }

    private JViewport __viewport1__ = null;
    public JViewport getViewport1(){
        if(__viewport1__ == null){
            JViewport result = new JViewport();
            Vector childs = getViewport1Childs();
            for (Object child : childs) result.add((Component) child);

            __viewport1__ = result;
        }
        return __viewport1__;
    }

    public Vector getViewport1Childs(){
        Vector<Object> result = new Vector<Object>();
        result.add(getTable99());
        return result;
    }

    private JPanel __table99__ = null;
    public JPanel getTable99(){
        if(__table99__ == null){
            Vector childs = getTable99Childs();
            GridBagConstraints [] cs = new GridBagConstraints[childs.size()];
            GridBagConstraints c;

            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.weightx = 1;
            c.weighty = 1;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.fill = GridBagConstraints.BOTH;
            cs[0] = c;

            JPanel result = new JPanel(new GridBagLayout());
            for(int i=0; i<childs.size(); i++)
                result.add((Component)childs.get(i), cs[i]);

            __table99__ = result;
        }
        return __table99__;
    }

    public Vector getTable99Childs(){
        Vector<Object> result = new Vector<Object>();
        result.add(getGraphPanel());
        return result;
    }

    private javax.swing.JPanel __graphPanel__ = null;
    public javax.swing.JPanel getGraphPanel(){
        if(__graphPanel__ == null){
            javax.swing.JPanel result = new javax.swing.JPanel();

            __graphPanel__ = result;
        }
        return __graphPanel__;
    }

    private JComboBox __graphRendererCombo__ = null;
    public JComboBox getGraphRendererCombo(){
        if(__graphRendererCombo__ == null){
            JComboBox result = new JComboBox();
            result.setEditable(true);
            result.addItemListener(new ItemListener(){
                public void itemStateChanged(ItemEvent e){
                    on_graphRendererCombo_selectionChanged(e);
                }
            });

            __graphRendererCombo__ = result;
        }
        return __graphRendererCombo__;
    }

    private JPanel __table1__ = null;
    public JPanel getTable1(){
        if(__table1__ == null){
            Vector childs = getTable1Childs();
            GridBagConstraints [] cs = new GridBagConstraints[childs.size()];
            GridBagConstraints c;

            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.weightx = 1;
            c.weighty = 1;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.fill = GridBagConstraints.BOTH;
            cs[0] = c;

            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 1;
            c.weightx = 1;
            c.weighty = 1;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.fill = GridBagConstraints.NONE;
            cs[1] = c;

            JPanel result = new JPanel(new GridBagLayout());
            for(int i=0; i<childs.size(); i++)
                result.add((Component)childs.get(i), cs[i]);

            __table1__ = result;
        }
        return __table1__;
    }

    public Vector getTable1Childs(){
        Vector<Object> result = new Vector<Object>();
        result.add(getTable2());
        result.add(getAppliquer());
        return result;
    }

    private JPanel __table2__ = null;
    public JPanel getTable2(){
        if(__table2__ == null){
            Vector childs = getTable2Childs();
            GridBagConstraints [] cs = new GridBagConstraints[childs.size()];
            GridBagConstraints c;

            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.weightx = 1;
            c.weighty = 1;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.fill = GridBagConstraints.BOTH;
            cs[0] = c;

            JPanel result = new JPanel(new GridBagLayout());
            for(int i=0; i<childs.size(); i++)
                result.add((Component)childs.get(i), cs[i]);

            __table2__ = result;
        }
        return __table2__;
    }

    public Vector getTable2Childs(){
        Vector<Object> result = new Vector<Object>();
        result.add(getPalettePanel());
        return result;
    }

    private javax.swing.JPanel __palettePanel__ = null;
    public javax.swing.JPanel getPalettePanel(){
        if(__palettePanel__ == null){
            javax.swing.JPanel result = new javax.swing.JPanel();

            __palettePanel__ = result;
        }
        return __palettePanel__;
    }

    private JButton __appliquer__ = null;
    public JButton getAppliquer(){
        if(__appliquer__ == null){
            ImageIcon icon = null;

            JButton result = new JButton(_("isisfish.common.apply"), icon);
            result.addMouseListener(new MouseAdapter(){
                public void mouseClicked(MouseEvent e){
                    on_appliquer_clicked();
                }
            });

            __appliquer__ = result;
        }
        return __appliquer__;
    }



}
