package fr.ifremer.isisfish.ui.result;

import java.awt.event.ItemEvent;

import javax.swing.DefaultComboBoxModel;
import javax.swing.JPanel;

import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.editor.ChartEditor;
import org.jfree.chart.editor.ChartEditorManager;
import org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import org.jfree.chart.renderer.category.AreaRenderer;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.BarRenderer3D;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.IntervalBarRenderer;
import org.jfree.chart.renderer.category.LayeredBarRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.renderer.category.LineRenderer3D;
import org.jfree.chart.renderer.category.MinMaxCategoryRenderer;
import org.jfree.chart.renderer.category.StackedAreaRenderer;
import org.jfree.chart.renderer.category.StackedBarRenderer;
import org.jfree.chart.renderer.category.StackedBarRenderer3D;

/**
 * GraphBean.
 *
 * Created: Mon Apr 29 17:48:40 2002
 *
 * @author <a href="mailto:seb.regnier@free.fr"></a>
 * @version $Revision: 2787 $
 */
public class GraphBean extends GraphBeanUI implements GraphBeanUICallback,
        GraphListener {

    /** serialVersionUID */
    private static final long serialVersionUID = -4474836708965453250L;

    protected GraphBeanModel model;
    protected JPanel graphPalette;
    protected ChartPanel chartPanel;
    protected JFreeChart chart;

    public GraphBean() {
        super();
        init();
        getGraphRendererCombo().setEditable(false);
        getGraphRendererCombo().setRenderer(new GraphComboRenderer());
        loadGraphRendererCombo();
    }

    protected void loadGraphRendererCombo() {
        DefaultComboBoxModel model = new DefaultComboBoxModel();

        // rendu : vertical bar
        BarRenderer barRenderer = new BarRenderer();
        barRenderer.setBaseToolTipGenerator(new StandardCategoryToolTipGenerator());
        model.addElement(barRenderer);

        // rendu : vertical bar 3d
        BarRenderer3D barRenderer3D = new BarRenderer3D();
        barRenderer3D.setBaseToolTipGenerator(new StandardCategoryToolTipGenerator());
        model.addElement(barRenderer3D);

        // rendu stacked bar
        StackedBarRenderer stackedBarRenderer = new StackedBarRenderer();
        stackedBarRenderer.setBaseToolTipGenerator(new StandardCategoryToolTipGenerator());
        model.addElement(stackedBarRenderer);
        
        // rendu aire
        AreaRenderer areaRenderer = new AreaRenderer();
        areaRenderer.setBaseToolTipGenerator(new StandardCategoryToolTipGenerator());
        model.addElement(areaRenderer);
        
        // rendu aire empilée
        StackedAreaRenderer stackedAreaRenderer = new StackedAreaRenderer();
        stackedAreaRenderer.setBaseToolTipGenerator(new StandardCategoryToolTipGenerator());
        model.addElement(stackedAreaRenderer);
        
        // rendu line aire
        LineAndShapeRenderer lineAndShapeRenderer = new LineAndShapeRenderer();
        lineAndShapeRenderer.setBaseToolTipGenerator(new StandardCategoryToolTipGenerator());
        model.addElement(lineAndShapeRenderer);
        
        // rendu ligne 3d
        LineRenderer3D lineRenderer3D = new LineRenderer3D();
        lineRenderer3D.setBaseToolTipGenerator(new StandardCategoryToolTipGenerator());
        model.addElement(lineRenderer3D);
        
        // rendu mix/max
        MinMaxCategoryRenderer minMaxCategoryRenderer = new MinMaxCategoryRenderer();
        minMaxCategoryRenderer.setBaseToolTipGenerator(new StandardCategoryToolTipGenerator());
        model.addElement(minMaxCategoryRenderer);

        model.setSelectedItem(null);
        getGraphRendererCombo().setModel(model);
    }

    /**
     * Get the value of model.
     * @return value of model.
     */
    public GraphBeanModel getModel() {
        return model;
    }

    /**
     * Set the value of model.
     * @param v  Value to assign to model.
     */
    public void setModel(GraphBeanModel v) {
        this.model = v;
        model.addGraphListener(this);
        // displayGraph();
    }

    public void graphChanged(GraphEvent e) {
        displayGraph();
    }

    /**
     * Get the value of chartPanel.
     * @return value of chartPanel.
     */
    public ChartPanel getChartPanel() {
        return chartPanel;
    }

    /**
     * Set the value of chartPanel.
     * @param v  Value to assign to chartPanel.
     */
    public void setChartPanel(ChartPanel v) {
        this.chartPanel = v;
    }

    /**
     * Get the value of graphPalette.
     * @return value of graphPalette.
     */
    public JPanel getGraphPalette() {
        return graphPalette;
    }

    /**
     * Set the value of graphPalette.
     * @param v  Value to assign to graphPalette.
     */
    public void setGraphPalette(JPanel v) {
        this.graphPalette = v;
    }

    /**
     * Get the value of chart.
     * @return value of chart.
     */
    public JFreeChart getChart() {
        return chart;
    }

    /**
     * Set the value of chart.
     * @param v  Value to assign to chart.
     */
    public void setChart(JFreeChart v) {
        this.chart = v;
    }

    public void displayGraph() {

        JFreeChart chart = new JFreeChart(getModel().getTitle(),
                JFreeChart.DEFAULT_TITLE_FONT, getModel().getCategoryPlot(), true);

        setChart(chart);
        setChartPanel(new ChartPanel(chart));

        // C'est un DefaultChartEditor (mais en visibilite package)
        // qui etend JPanel et ChartEditor (en version 1.0.13 du moins)
        setGraphPalette((JPanel) ChartEditorManager.getChartEditor(this.chart));

        //getGraphSplitPane().setDividerLocation(1.0);

        getGraphPanel().removeAll();
        getPalettePanel().removeAll();
        getGraphPanel().add(getChartPanel());
        getPalettePanel().add(getGraphPalette());
        getGraphPanel().invalidate();
        getPalettePanel().invalidate();
        getGraphPanel().validate();
        getPalettePanel().validate();
        getGraphPanel().repaint();
        getPalettePanel().repaint();
    }

    public void on_appliquer_clicked() {
        ((ChartEditor) getGraphPalette()).updateChart(getChart());
    }

    public void on_graphRendererCombo_selectionChanged(ItemEvent e) {
        if (e.getStateChange() == ItemEvent.SELECTED) {
            getModel().setRenderer(
                    (CategoryItemRenderer) getGraphRendererCombo()
                            .getSelectedItem());
        }
    }

}// GraphBean
