/* *##%
 * Copyright (C) 2009 Code Lutin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *##%*/

package fr.ifremer.isisfish.ui.models.simulation;

import java.util.List;

import javax.swing.DefaultComboBoxModel;

/**
 * Model pour la liste des simulations (leurs noms seulement).
 *
 * @author chatellier
 * @version $Revision: 2436 $
 * 
 * Last update : $Date: 2009-06-25 17:46:01 +0200 (jeu., 25 juin 2009) $
 * By : $Author: chatellier $
 */
public class SimulationNamesComboModel extends DefaultComboBoxModel {

    /** serialVersionUID. */
    private static final long serialVersionUID = -4070846632975105788L;

    /** SensitivityCalculator names. */
    protected List<String> simulationsNames;

    /**
     * Empty constructor.
     */
    public SimulationNamesComboModel() {
        this(null);
    }

    /**
     * Constructor with simulation list.
     * 
     * @param simulationsNames simulation names
     */
    public SimulationNamesComboModel(List<String> simulationsNames) {
        super();
        setSimulationNames(simulationsNames);
    }

    /**
     * Get simulations names.
     * 
     * @return the simulations names
     */
    public List<String> getSimulationNames() {
        return simulationsNames;
    }

    /**
     * Set simulation names.
     * 
     * @param simulationsNames the names to set
     */
    public void setSimulationNames(List<String> simulationsNames) {
        this.simulationsNames = simulationsNames;
    }

    /*
     * @see javax.swing.ListModel#getElementAt(int)
     */
    @Override
    public Object getElementAt(int index) {
        return simulationsNames.get(index);
    }

    /*
     * @see javax.swing.ListModel#getSize()
     */
    @Override
    public int getSize() {
        int size = 0;

        if (simulationsNames != null) {
            size = simulationsNames.size();
        }
        return size;
    }
}
