/* *##%
 * Copyright (C) 2009 Code Lutin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *##%*/

package fr.ifremer.isisfish.ui.models.sensitivityexport;

import java.awt.Component;

import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

import fr.ifremer.isisfish.datastore.SensitivityExportStorage;
import fr.ifremer.isisfish.export.SensitivityExport;
import fr.ifremer.isisfish.ui.util.TooltipHelper;
import fr.ifremer.isisfish.util.Doc;

/**
 * Specific renderer for export parameters.
 *
 * @author chatellier
 * @version $Revision: 2583 $
 * 
 * Last update : $Date: 2009-09-04 16:59:18 +0200 (ven., 04 sept. 2009) $
 * By : $Author: chatellier $
 */
public class SensitivityExportParametersTableCellRenderer extends DefaultTableCellRenderer
        implements TableCellRenderer {

    /** serialVersionUID. */
    private static final long serialVersionUID = -1655744662816030649L;

    protected SensitivityExport export;

    public SensitivityExportParametersTableCellRenderer(SensitivityExport export) {
        this.export = export;
    }

    /*
     * @see javax.swing.table.TableCellRenderer#getTableCellRendererComponent(javax.swing.JTable, java.lang.Object, boolean, boolean, int, int)
     */
    @Override
    public Component getTableCellRendererComponent(JTable table, Object value,
            boolean isSelected, boolean hasFocus, int row, int column) {

        // this must be used to have alterned highlight rows and default
        // selection color
        JLabel c = (JLabel) super.getTableCellRendererComponent(table, value,
                isSelected, hasFocus, row, column);

        String parameterName = (String) value;
        c.setText(parameterName);

        Doc doc = SensitivityExportStorage.getParameterDoc(export, parameterName);
        String documentation = TooltipHelper.docToString(doc);
        c.setToolTipText(documentation);

        return c;
    }

}
