/* *##%
 * Copyright (C) 2009 Code Lutin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *##%*/

package fr.ifremer.isisfish.ui.models.sensitivityexport;

import java.util.List;

import javax.swing.AbstractListModel;

import fr.ifremer.isisfish.export.SensitivityExport;

/**
 * Model pour la liste des instances d'exports.
 *
 * @author chatellier
 * @version $Revision: 2583 $
 * 
 * Last update : $Date: 2009-09-04 16:59:18 +0200 (ven., 04 sept. 2009) $
 * By : $Author: chatellier $
 */
public class SensitivityExportListModel extends AbstractListModel {

    /** serialVersionUID. */
    private static final long serialVersionUID = -4070846632975105788L;

    protected List<SensitivityExport> exports;

    /**
     * Empty constructor.
     */
    public SensitivityExportListModel() {
        this(null);
    }

    /**
     * Constructor with plan list.
     * 
     * @param exports exports
     */
    public SensitivityExportListModel(List<SensitivityExport> exports) {
        super();
        setSensitivityExports(exports);
    }

    /**
     * Get exports list.
     * 
     * @return the exports
     */
    public List<SensitivityExport> getSensitivityExports() {
        return exports;
    }

    /**
     * Set exports list.
     * 
     * @param exports the exports to set
     */
    public void setSensitivityExports(List<SensitivityExport> exports) {
        this.exports = exports;
    }

    /*
     * @see javax.swing.ListModel#getElementAt(int)
     */
    @Override
    public Object getElementAt(int index) {
        return exports.get(index);
    }

    /*
     * @see javax.swing.ListModel#getSize()
     */
    @Override
    public int getSize() {
        int size = 0;

        if (exports != null) {
            size = exports.size();
        }
        return size;
    }
}
