/* *##%
 * Copyright (C) 2009 Code Lutin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *##%*/

package fr.ifremer.isisfish.ui.models.sensitivity;

import java.awt.Component;

import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

import fr.ifremer.isisfish.datastore.SensitivityStorage;
import fr.ifremer.isisfish.simulator.sensitivity.SensitivityCalculator;

/**
 * Renderer pour la liste des plans d'analyse.
 *
 * @author chatellier
 * @version $Revision: 2418 $
 * 
 * Last update : $Date: 2009-06-22 14:52:27 +0200 (lun., 22 juin 2009) $
 * By : $Author: chatellier $
 */
public class SensitivityCalculatorListRenderer extends DefaultListCellRenderer implements
        ListCellRenderer {

    /** serialVersionUID. */
    private static final long serialVersionUID = -4070846632975105788L;

    /*
     * @see javax.swing.ListCellRenderer#getListCellRendererComponent(javax.swing.JList, java.lang.Object, int, boolean, boolean)
     */
    @Override
    public Component getListCellRendererComponent(JList list, Object value,
            int index, boolean isSelected, boolean cellHasFocus) {

        // this must be used to have alterned highlight rows and default
        // selection color
        JLabel c = (JLabel) super.getListCellRendererComponent(list, value,
                index, isSelected, cellHasFocus);

        SensitivityCalculator sensitivity = (SensitivityCalculator) value;
        c.setText(SensitivityStorage.getName(sensitivity));

        try {
            c.setToolTipText(sensitivity.getDescription());
        } catch (Exception e) {
            // can't get exception
        }

        return this;
    }
}
