/* *##%
 * Copyright (C) 2009 Code Lutin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *##%*/

package fr.ifremer.isisfish.ui.models.sensitivity;

import static org.nuiton.i18n.I18n._;

import java.awt.Component;
import java.util.HashMap;
import java.util.Map;

import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

import fr.ifremer.isisfish.datastore.SensitivityStorage;
import fr.ifremer.isisfish.simulator.sensitivity.SensitivityCalculator;
import fr.ifremer.isisfish.ui.util.TooltipHelper;

/**
 * Renderer pour la combo des calculateurs de sensibilités.
 *
 * @author chatellier
 * @version $Revision: 2658 $
 * 
 * Last update : $Date: 2009-10-13 17:00:50 +0200 (mar., 13 oct. 2009) $
 * By : $Author: chatellier $
 */
public class SensitivityCalculatorComboRenderer extends DefaultListCellRenderer implements
        ListCellRenderer {

    /** serialVersionUID. */
    private static final long serialVersionUID = -4070846632975105788L;

    /** Sensitivity cache. */
    protected Map<String, SensitivityCalculator> sensitivityCalculatorCache;

    /**
     * Empty constructor.
     */
    public SensitivityCalculatorComboRenderer() {
        sensitivityCalculatorCache = new HashMap<String, SensitivityCalculator>();
    }

    /*
     * @see javax.swing.ListCellRenderer#getListCellRendererComponent(javax.swing.JList, java.lang.Object, int, boolean, boolean)
     */
    @Override
    public Component getListCellRendererComponent(JList list, Object value,
            int index, boolean isSelected, boolean cellHasFocus) {

        // this must be used to have alterned highlight rows and default
        // selection color
        JLabel c = (JLabel) super.getListCellRendererComponent(list, value,
                index, isSelected, cellHasFocus);

        String sensitivityName = (String) value;
        c.setText(sensitivityName);

        // c'est tres couteux d'avoir une instance
        // on les met en cache
        try {
            SensitivityCalculator plan = sensitivityCalculatorCache.get(sensitivityName);
            if (plan == null) {
                SensitivityStorage storage = SensitivityStorage
                        .getSensitivity(sensitivityName);
                plan = storage.getNewSensitivityInstance();
                sensitivityCalculatorCache.put(sensitivityName, plan);
            }

            c.setToolTipText(plan.getDescription());
        } catch (Exception e) {
            String errorTooltip = TooltipHelper.getErrorTooltip(_("isisfish.error.compile.fileerror", sensitivityName));
            c.setToolTipText(errorTooltip);
        }

        return c;
    }
}
