/* *##%
 * Copyright (C) 2009 Code Lutin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *##%*/

package fr.ifremer.isisfish.ui.models.rule;

import java.awt.Component;

import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

import fr.ifremer.isisfish.datastore.RuleStorage;
import fr.ifremer.isisfish.rule.Rule;
import fr.ifremer.isisfish.ui.util.TooltipHelper;
import fr.ifremer.isisfish.util.Doc;

/**
 * Specific editor for rule parameters.
 *
 * @author chatellier
 * @version $Revision: 2418 $
 * 
 * Last update : $Date: 2009-06-22 14:52:27 +0200 (lun., 22 juin 2009) $
 * By : $Author: chatellier $
 */
public class RuleParametersTableCellRenderer extends DefaultTableCellRenderer
        implements TableCellRenderer {

    /** serialVersionUID. */
    private static final long serialVersionUID = -1655744662816030649L;

    protected Rule rule;

    public RuleParametersTableCellRenderer(Rule rule) {
        this.rule = rule;

    }

    /*
     * @see javax.swing.table.TableCellRenderer#getTableCellRendererComponent(javax.swing.JTable, java.lang.Object, boolean, boolean, int, int)
     */
    @Override
    public Component getTableCellRendererComponent(JTable table, Object value,
            boolean isSelected, boolean hasFocus, int row, int column) {

        JLabel c = (JLabel) super.getTableCellRendererComponent(table, value,
                isSelected, hasFocus, row, column);

        String parameterName = (String) value;
        c.setText(parameterName);

        Doc doc = RuleStorage.getParameterDoc(rule, parameterName);
        String documentation = TooltipHelper.docToString(doc);
        c.setToolTipText(documentation);

        return c;
    }

}
