/* *##%
 * Copyright (C) 2009 Code Lutin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *##%*/

package fr.ifremer.isisfish.ui.models.rule;

import java.awt.Component;
import java.util.List;

import javax.swing.AbstractListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

import fr.ifremer.isisfish.datastore.RuleStorage;
import fr.ifremer.isisfish.rule.Rule;

/**
 * Model pour la liste des regles des parametres d'une simulation.
 *
 * @author chatellier
 * @version $Revision: 2418 $
 * 
 * Last update : $Date: 2009-06-22 14:52:27 +0200 (lun., 22 juin 2009) $
 * By : $Author: chatellier $
 */
public class RuleListModel extends AbstractListModel implements
        ListCellRenderer {

    /** serialVersionUID. */
    private static final long serialVersionUID = -4070846632975105788L;

    protected List<Rule> rules;

    /**
     * Empty constructor.
     */
    public RuleListModel() {
        this(null);
    }

    /**
     * Constructor with rule list.
     * 
     * @param rules rules
     */
    public RuleListModel(List<Rule> rules) {
        super();
        this.rules = rules;
    }

    /**
     * Get rules list.
     * 
     * @return the rules
     */
    public List<Rule> getRules() {
        return rules;
    }

    /**
     * Set rules list.
     * 
     * @param rules the rules to set
     */
    public void setRules(List<Rule> rules) {
        this.rules = rules;
    }

    /*
     * @see javax.swing.ListModel#getElementAt(int)
     */
    @Override
    public Object getElementAt(int index) {
        return rules.get(index);
    }

    /*
     * @see javax.swing.ListModel#getSize()
     */
    @Override
    public int getSize() {
        int size = 0;

        if (rules != null) {
            size = rules.size();
        }
        return size;
    }

    /*
     * @see javax.swing.ListCellRenderer#getListCellRendererComponent(javax.swing.JList, java.lang.Object, int, boolean, boolean)
     */
    @Override
    public Component getListCellRendererComponent(JList list, Object value,
            int index, boolean isSelected, boolean cellHasFocus) {

        Rule rule = rules.get(index);

        JLabel label = new JLabel();

        try {
            label.setToolTipText(rule.getDescription());
        } catch (Exception e) {
            // can't get exception
        }
        label.setText(RuleStorage.getName(rule));

        if (isSelected) {
            label.setBackground(list.getSelectionBackground());
            label.setForeground(list.getSelectionForeground());
            label.setOpaque(true); // background won't work
        }

        return label;
    }
}
