/* *##%
 * Copyright (C) 2009 Code Lutin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *##%*/

package fr.ifremer.isisfish.ui.models.rule;

import java.util.List;

import javax.swing.DefaultComboBoxModel;

/**
 * Model pour la liste des noms de regles.
 *
 * @author chatellier
 * @version $Revision: 2418 $
 * 
 * Last update : $Date: 2009-06-22 14:52:27 +0200 (lun., 22 juin 2009) $
 * By : $Author: chatellier $
 */
public class RuleComboModel extends DefaultComboBoxModel {

    /** serialVersionUID. */
    private static final long serialVersionUID = -4070846632975105788L;

    /** Analyze plan names. */
    protected List<String> rulesNames;

    /**
     * Empty constructor.
     */
    public RuleComboModel() {
        this(null);
    }

    /**
     * Constructor with rule names list.
     * 
     * @param rulesNames exports Names
     */
    public RuleComboModel(List<String> rulesNames) {
        super();
        setExportNames(rulesNames);
    }

    /**
     * Get rule names.
     * 
     * @return the analyze plan names
     */
    public List<String> getExportNames() {
        return rulesNames;
    }

    /**
     * Set rule names.
     * 
     * @param rulesNames the rule names to set
     */
    public void setExportNames(List<String> rulesNames) {
        this.rulesNames = rulesNames;

        // default first selected
        if (!rulesNames.isEmpty()) {
            setSelectedItem(rulesNames.get(0));
        }
    }

    /*
     * @see javax.swing.ListModel#getElementAt(int)
     */
    @Override
    public Object getElementAt(int index) {
        return rulesNames.get(index);
    }

    /*
     * @see javax.swing.ListModel#getSize()
     */
    @Override
    public int getSize() {
        int size = 0;

        if (rulesNames != null) {
            size = rulesNames.size();
        }
        return size;
    }
}
