/* *##%
 * Copyright (C) 2009 Code Lutin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *##%*/

package fr.ifremer.isisfish.ui.models.export;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import fr.ifremer.isisfish.datastore.ExportStorage;
import fr.ifremer.isisfish.export.Export;
import fr.ifremer.isisfish.ui.widget.editor.ParameterTableCellEditor;

/**
 * Specific editor for export parameters.
 *
 * @author chatellier
 * @version $Revision: 2418 $
 * 
 * Last update : $Date: 2009-06-22 14:52:27 +0200 (lun., 22 juin 2009) $
 * By : $Author: chatellier $
 */
public class ExportParametersTableCellEditor extends ParameterTableCellEditor {

    /** serialVersionUID. */
    private static final long serialVersionUID = 8211639776194497615L;

    protected Export export;

    protected List<Class<?>> exportParametersTypes;

    /**
     * Constructor with export parameter.
     * 
     * @param export export
     */
    public ExportParametersTableCellEditor(Export export) {
        super();

        this.export = export;
        exportParametersTypes = new ArrayList<Class<?>>();
        //TODO map may be sorted
        Map<String, Class<?>> planParametersNamesAndTypes = ExportStorage
                .getParameterNames(export);
        for (Class<?> type : planParametersNamesAndTypes.values()) {
            exportParametersTypes.add(type);
        }
    }

    /*
     * @see fr.ifremer.isisfish.ui.widget.editor.ParameterTableCellEditor#getType(java.lang.Object, int, int)
     */
    @Override
    protected Class<?> getType(Object value, int row, int column) {
        return exportParametersTypes.get(row);
    }
}
