/* *##%
 * Copyright (C) 2009 Code Lutin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *##%*/

package fr.ifremer.isisfish.ui.models.analyzeplan;

import static org.nuiton.i18n.I18n._;

import java.awt.Component;
import java.util.HashMap;
import java.util.Map;

import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

import fr.ifremer.isisfish.datastore.AnalysePlanStorage;
import fr.ifremer.isisfish.simulator.AnalysePlan;
import fr.ifremer.isisfish.ui.util.TooltipHelper;

/**
 * Renderer pour la combo des plans d'analyse.
 *
 * @author chatellier
 * @version $Revision: 2658 $
 * 
 * Last update : $Date: 2009-10-13 17:00:50 +0200 (mar., 13 oct. 2009) $
 * By : $Author: chatellier $
 */
public class AnalyzePlanComboRenderer extends DefaultListCellRenderer implements
        ListCellRenderer {

    /** serialVersionUID. */
    private static final long serialVersionUID = -4070846632975105788L;

    /** Analyse plan cache. */
    protected Map<String, AnalysePlan> analysePlanCache;

    /**
     * Empty constructor.
     */
    public AnalyzePlanComboRenderer() {
        analysePlanCache = new HashMap<String, AnalysePlan>();
    }

    /*
     * @see javax.swing.ListCellRenderer#getListCellRendererComponent(javax.swing.JList, java.lang.Object, int, boolean, boolean)
     */
    @Override
    public Component getListCellRendererComponent(JList list, Object value,
            int index, boolean isSelected, boolean cellHasFocus) {

        // this must be used to have alterned highlight rows and default
        // selection color
        JLabel c = (JLabel) super.getListCellRendererComponent(list, value,
                index, isSelected, cellHasFocus);

        String analysePlanName = (String) value;
        c.setText(analysePlanName);

        // c'est tres couteux d'avoir une instance
        // on les met en cache
        try {
            AnalysePlan plan = analysePlanCache.get(analysePlanName);
            if (plan == null) {
                AnalysePlanStorage storage = AnalysePlanStorage
                        .getAnalysePlan(analysePlanName);
                plan = storage.getNewAnalysePlanInstance();
                analysePlanCache.put(analysePlanName, plan);
            }

            c.setToolTipText(plan.getDescription());
        } catch (Exception e) {
            String errorTooltip = TooltipHelper.getErrorTooltip(_("isisfish.error.compile.fileerror", analysePlanName));
            c.setToolTipText(errorTooltip);
        }

        return c;
    }
}
