/* *##%
 * Copyright (C) 2009 Code Lutin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *##%*/

package fr.ifremer.isisfish.ui.input.triptype;

import java.util.List;

import javax.swing.DefaultListModel;

import fr.ifremer.isisfish.entities.TripType;

/**
 * Model pour la liste des {@link TripType}.
 * 
 * Pas de selection par defaut.
 *
 * @author chatellier
 * @version $Revision: 2743 $
 * 
 * Last update : $Date: 2009-11-05 16:22:34 +0100 (jeu., 05 nov. 2009) $
 * By : $Author: chatellier $
 */
public class TripTypeListModel extends DefaultListModel {

    /** serialVersionUID. */
    private static final long serialVersionUID = 6171850179969290032L;

    /** Trip types list */
    protected List<TripType> tripTypes;

    /**
     * Constructor with trip types list.
     * 
     * @param tripTypes Trip types list
     */
    public TripTypeListModel(List<TripType> tripTypes) {
        super();
        this.tripTypes = tripTypes;
    }

    /*
     * @see javax.swing.ListModel#getElementAt(int)
     */
    @Override
    public Object getElementAt(int index) {
        return tripTypes.get(index);
    }

    /*
     * @see javax.swing.ListModel#getSize()
     */
    @Override
    public int getSize() {
        int size = 0;

        if (tripTypes != null) {
            size = tripTypes.size();
        }
        return size;
    }
}
